/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

import com.huawei.uflight.trapconnector.core.TrapMSGHead;

public class TrapMSGPacket {
    private TrapMSGHead mheader;
    private byte[] data;

    public TrapMSGPacket() {
        this.mheader = new TrapMSGHead();
    }

    public TrapMSGPacket(TrapMSGHead head, byte[] data) {
        this(head, data, data != null ? data.length : 0);
    }

    public TrapMSGPacket(TrapMSGHead head, byte[] data, int len) {
        if (head == null) {
            throw new IllegalArgumentException("MSGHead is null.");
        }
        this.mheader = head;
        if (data != null && len > 0) {
            int validLen = len > data.length ? data.length : len;
            this.mheader.setContentLen(validLen);
            this.data = new byte[validLen];
            System.arraycopy(data, 0, this.data, 0, validLen);
        } else {
            this.mheader.setContentLen(0);
            this.data = null;
        }
    }

    public byte[] toByte() {
        byte[] packetBytes = new byte[this.mheader.getContentLen() + 36];
        System.arraycopy(this.mheader.toByte(), 0, packetBytes, 0, 36);
        if (this.data != null && this.data.length > 0) {
            System.arraycopy(this.data, 0, packetBytes, 36, this.data.length);
        }
        return packetBytes;
    }

    public byte[] getData() {
        return this.data;
    }

    public void clearData() {
        this.data = null;
    }

    public int length() {
        if (this.data != null) {
            return 36 + this.data.length;
        }
        return 36;
    }

    public int getCmdCode() {
        if (this.mheader == null) {
            return 0;
        }
        return this.mheader.getCmdCode();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.mheader.toString());
        buf.append(" dataLength=");
        return buf.toString();
    }

    public TrapMSGHead getMheader() {
        return this.mheader;
    }

    public void setMheader(TrapMSGHead mheader) {
        this.mheader = mheader;
    }
}

