/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.uflight.trapconnector.TrapReceiverInfo;
import com.huawei.uflight.trapconnector.asn.AsnFaultTrapReceiverReload;
import com.huawei.uflight.trapconnector.core.CommReader;
import com.huawei.uflight.trapconnector.core.CommStateEvent;
import com.huawei.uflight.trapconnector.core.CommStateListener;
import com.huawei.uflight.trapconnector.core.ConnectTask;
import com.huawei.uflight.trapconnector.core.DataAccepter;
import com.huawei.uflight.trapconnector.core.HandShakeTask;
import com.huawei.uflight.trapconnector.core.MSGListener;
import com.huawei.uflight.trapconnector.core.MSGSyncReceiver;
import com.huawei.uflight.trapconnector.core.MsgIDGenerator;
import com.huawei.uflight.trapconnector.core.Reconnector;
import com.huawei.uflight.trapconnector.core.TrapMSGHead;
import com.huawei.uflight.trapconnector.core.TrapMSGPacket;
import com.huawei.uflight.trapconnector.core.TrapMsgDispatcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapCommHandle {
    private static Logger logger = LoggerFactory.getLogger(TrapCommHandle.class);
    private static final int CONNECTER_INTERVAL = 10000;
    private static final int HAND_INTERVAL = 30000;
    private static final int MIN_HANDSHAKE_INTERVAL = 20000;
    private static final int REGISTER_TIMEOUT = 40000;
    static final int MIN_TIMEOUT = 1000;
    private static final int DEFAULT_TIMEOUT = 45000;
    private static final int DEFAULT_HANDSHAKE_TIMEOUT = 60000;
    private static final int ONE_SECOND = 1000;
    private static final int REGISTER_DATA_LEN = 1;
    private static int shakeHandTimeOut = 60000;
    private Reconnector reconnetor = new Reconnector(new Properties());
    private TrapReceiverInfo trapSvrInfo = null;
    private Socket socket = null;
    private BufferedInputStream in = null;
    private BufferedOutputStream out = null;
    private DataAccepter dataAccepter = null;
    private CommReader reader = null;
    private TrapMsgDispatcher dispatcher = null;
    private int timeout = 45000;
    private Timer shakeTimer = null;
    private HandShakeTask shakeTask = null;
    private Timer connectTimer = null;
    private ConnectTask connectTask = null;
    private char procID = '\u0000';
    private char procHandle = '\u0000';
    private byte state = (byte)-3;
    private TrapMSGPacket handShakeMsg = null;
    private long lastEchoTime = 0L;
    private CommStateListener stateListener = null;
    private boolean closed = false;
    private volatile boolean handleErrorStarted = false;
    private ReconnectCloseLock closeReconnectLock = new ReconnectCloseLock();

    public void connect(TrapReceiverInfo connTrapSvrInfo, char curProcID) throws IOException {
        this.trapSvrInfo = connTrapSvrInfo;
        this.procID = curProcID;
        this.startConnect();
    }

    private void startConnect() {
        this.connectTimer = new Timer();
        this.connectTask = new ConnectTask(this);
        this.connectTimer.schedule((TimerTask)this.connectTask, 0L, 10000L);
    }

    final void connectServer() {
        if (!this.openSocket(this.trapSvrInfo.getCServerIP(), this.trapSvrInfo.getIServerLstPort())) {
            return;
        }
        this.stopConnectTask();
        this.dataAccepter = new DataAccepter();
        this.reader.setAccepter(this.dataAccepter);
        this.dispatcher = new TrapMsgDispatcher(this, this.dataAccepter);
        this.dispatcher.start();
        this.state = 1;
        this.startHandShake();
        this.registerConn();
    }

    private boolean openSocket(String hostName, int hostPort) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("Open socket with ");
            buf.append(hostName);
            buf.append(':');
            buf.append(hostPort);
            logger.info(buf.toString());
            this.socket = new Socket(hostName, hostPort);
            this.socket.setTcpNoDelay(true);
        }
        catch (IOException ioe) {
            TrapCommHandle.logException(ioe);
            return false;
        }
        catch (Exception e) {
            TrapCommHandle.logException(e);
            return false;
        }
        try {
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.in = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (Exception e) {
            try {
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (Exception e1) {
                TrapCommHandle.logException(e1);
            }
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (Exception e2) {
                TrapCommHandle.logException(e2);
            }
            return false;
        }
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = new CommReader(this, this.in, this.dataAccepter);
        this.reader.start();
        return true;
    }

    private void registerConn() {
        TrapMSGHead head = new TrapMSGHead();
        head.setContentLen(1);
        head.setSendProcID(this.procID);
        head.setRecvProcID(10000);
        head.setPriority(1);
        head.setCmdCode(4);
        head.setMsgType(5);
        head.setTrapRecvID(1);
        head.setSendIP(0);
        head.setMsgID(MsgIDGenerator.generate());
        byte[] data = new byte[1];
        TrapMSGPacket msg = new TrapMSGPacket(head, data);
        try {
            this.sendAsyncMessage(msg, null, 40000);
        }
        catch (IOException e) {
            logger.error("regist trap connector fail.", (Throwable)e);
        }
    }

    private void startHandShake() {
        this.shakeTimer = new Timer();
        this.shakeTask = new HandShakeTask(this);
        this.shakeTimer.schedule((TimerTask)this.shakeTask, 30000L, 30000L);
    }

    public int notifyReloadNBC(String condition) {
        TrapMSGHead head = new TrapMSGHead();
        head.setSendProcID(this.procID);
        head.setRecvProcID(10000);
        head.setPriority(1);
        head.setCmdCode(20);
        head.setMsgType(1);
        head.setTrapRecvID(1);
        head.setSendIP(0);
        head.setMsgID(MsgIDGenerator.generate());
        AsnFaultTrapReceiverReload req = new AsnFaultTrapReceiverReload();
        req.condition = condition.getBytes();
        AsnFaultTrapReceiverReload rsp = new AsnFaultTrapReceiverReload();
        int ret = 0;
        try {
            byte[] data = AsnCoder.serialize((FStruct)req);
            head.setContentLen(data.length);
            TrapMSGPacket msgReq = new TrapMSGPacket(head, data);
            MSGSyncReceiver recv = new MSGSyncReceiver();
            ret = this.sendSyncMessage(msgReq, recv, 45000);
            if (0 != ret) {
                logger.error("[notifyReloadBC] sendSyncMessage failure, ret = " + ret);
                return ret;
            }
            TrapMSGPacket msgRsp = recv.getResult();
            if (null != msgRsp) {
                if (AsnCoder.deserialize((byte[])msgRsp.toByte(), (FStruct)rsp)) {
                    ret = rsp.errorCode.lError.intValue();
                } else {
                    ret = -3;
                    logger.error("[notifyReloadBC] rsp is null, ret = " + ret);
                }
            } else {
                ret = -3;
                logger.error("[notifyReloadBC] msgRsp is null, ret = " + ret);
            }
        }
        catch (FStruException e1) {
            logger.error("[notifyReloadBC] catch a exception.", (Throwable)e1);
        }
        catch (Exception e2) {
            logger.error("[notifyReloadBC] catch a exception.", (Throwable)e2);
        }
        return ret;
    }

    public synchronized void sendAsyncMessage(TrapMSGPacket packetExt, MSGListener listener, int times) throws IOException {
        if (this.state != 1) {
            logger.error("CommState is abnormal, state=" + this.state);
            throw new IOException();
        }
        if (packetExt == null) {
            throw new IllegalArgumentException("MSGPacketExt is null.");
        }
        int msgID = packetExt.getMheader().getMsgID();
        if (listener != null) {
            this.dispatcher.addMessageReceiver(msgID, listener, packetExt.getCmdCode(), times);
        }
        TrapCommHandle.logTrace("To socket\u00a3\u00ba", packetExt.getMheader());
        this.out.write(packetExt.toByte());
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int sendSyncMessage(TrapMSGPacket msg, MSGSyncReceiver recv, int times) throws IllegalArgumentException {
        if (null == recv) {
            throw new IllegalArgumentException("MSGSyncReceiver is null.");
        }
        MSGSyncReceiver mSGSyncReceiver = recv;
        synchronized (mSGSyncReceiver) {
            try {
                this.sendAsyncMessage(msg, recv, times);
                recv.setFlag(2);
                recv.wait();
            }
            catch (Exception ex) {
                TrapCommHandle.logException(ex);
                this.dispatcher.removeReceiver(msg.getMheader().getMsgID());
                return -3;
            }
            this.dispatcher.removeReceiver(msg.getMheader().getMsgID());
        }
        return recv.getFlag();
    }

    final void handshake() {
        if (null == this.handShakeMsg) {
            TrapMSGHead head = new TrapMSGHead();
            head.setContentLen(1);
            head.setSendProcID(this.procID);
            head.setRecvProcID(10000);
            head.setPriority(1);
            head.setCmdCode(3);
            head.setMsgType(4);
            head.setTrapRecvID(this.trapSvrInfo.getIServerID());
            head.setSendIP(0);
            head.setMsgID(MsgIDGenerator.generate());
            byte[] data = new byte[1];
            this.handShakeMsg = new TrapMSGPacket(head, data);
        }
        long curTime = System.currentTimeMillis();
        long lastTime = this.lastEchoTime;
        long subTime = curTime - lastTime;
        if (0L == this.lastEchoTime || subTime > 20000L && subTime <= (long)shakeHandTimeOut) {
            if (0L == this.lastEchoTime) {
                this.lastEchoTime = System.currentTimeMillis();
            }
            try {
                this.sendAsyncMessage(this.handShakeMsg, null, this.timeout);
            }
            catch (IOException e) {
                TrapCommHandle.logException(e);
                logger.error("Failed to send shakehand command to server!");
                this.handleError();
            }
        } else if (subTime > (long)shakeHandTimeOut) {
            logger.error("send shakehand command to server timeout! subTime =" + subTime);
            this.handleError();
        }
    }

    final void refresh() {
        this.lastEchoTime = System.currentTimeMillis();
    }

    public void handleError() {
        if (this.handleErrorStarted) {
            logger.info("come in handleError, but another thread already start a handleError, here just return.");
            return;
        }
        this.handleErrorStarted = true;
        logger.info("come in handleError, procID = " + this.procID);
        this.state = (byte)-3;
        if (this.dispatcher != null) {
            this.dispatcher.cancelReceivers();
        }
        if (!this.reconnetor.reconnect(this)) {
            logger.error("Recconnect failed in handleError.");
            this.close();
        } else {
            logger.info("Reconnect success!");
        }
        this.handleErrorStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconnect() {
        ReconnectCloseLock reconnectCloseLock = this.closeReconnectLock;
        synchronized (reconnectCloseLock) {
            if (this.closed) {
                return false;
            }
        }
        this.stopHandShake();
        this.closeSocket();
        reconnectCloseLock = this.closeReconnectLock;
        synchronized (reconnectCloseLock) {
            if (this.isClosed()) {
                return false;
            }
            if (!this.openSocket(this.trapSvrInfo.getCServerIP(), this.trapSvrInfo.getIServerLstPort())) {
                return false;
            }
            this.state = 1;
        }
        this.startHandShake();
        this.registerConn();
        this.refresh();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReconnectCloseLock reconnectCloseLock = this.closeReconnectLock;
        synchronized (reconnectCloseLock) {
            this.closed = true;
            if (this.state == 2) {
                logger.info("CommHandle had been closed");
                return;
            }
            this.state = (byte)2;
            this.stopConnectTask();
            this.stopHandShake();
            this.closeSocket();
            if (this.dispatcher != null) {
                this.dispatcher.close();
            }
            if (this.dataAccepter != null) {
                this.dataAccepter.close();
            }
            MsgIDGenerator.reset();
        }
    }

    public boolean isClosed() {
        return this.state == 2;
    }

    private void stopConnectTask() {
        if (this.connectTask != null && this.connectTimer != null) {
            this.connectTask.cancel();
            this.connectTimer.cancel();
            this.connectTask.comm = null;
            this.connectTask = null;
            this.connectTimer = null;
        }
    }

    private void stopHandShake() {
        if (this.shakeTask != null && this.shakeTimer != null) {
            this.shakeTask.cancel();
            this.shakeTimer.cancel();
            this.shakeTask.comm = null;
            this.shakeTask = null;
            this.shakeTimer = null;
        }
    }

    private void closeSocket() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.socket != null) {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
            catch (UnsupportedOperationException e) {
                logger.error(e.getMessage());
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
            catch (UnsupportedOperationException e) {
                logger.error(e.getMessage());
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                logger.error(ex.getMessage());
            }
            this.socket = null;
        }
    }

    public void cancelAsyncMessage(int msgID) {
        this.dispatcher.removeReceiver(msgID);
        this.dispatcher.removeTimeoutItem(msgID);
    }

    public void cancelAsyncMessage(MSGListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null.");
        }
        this.dispatcher.removeReceiver(listener);
        logger.info("CommHandle cancelAsyncMessage, listener:" + listener);
    }

    public boolean setTimeout(int time) {
        if (time >= 1000) {
            this.timeout = time;
            return true;
        }
        logger.info("Set timeout failed(time<1000): time=" + time);
        return false;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public static void setShakeHandTimeout(int timeout) {
        shakeHandTimeOut = timeout * 1000;
    }

    public void setStateListener(CommStateListener stateListener) {
        this.stateListener = stateListener;
    }

    public void stateChanged(CommStateEvent event) {
        if (this.stateListener != null) {
            this.stateListener.stateChanged(event);
        }
    }

    public char getProcID() {
        return this.procID;
    }

    public char getProcHandle() {
        return this.procHandle;
    }

    final TrapMsgDispatcher getMsgDispatcher() {
        return this.dispatcher;
    }

    static final void logTrace(String msg, TrapMSGHead mHead) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg).append(mHead.toString());
        logger.info(buf.toString());
    }

    private static void logException(Exception ex) {
        logger.warn("exception", (Throwable)ex);
    }

    static final void logTrace(String msg, TrapMSGPacket packetExt) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg).append(packetExt.toString());
        logger.info(buf.toString());
    }

    static final void logTrace(String msg, int cmdCode, int msgID) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg);
        buf.append(" cmdCode=");
        buf.append(cmdCode);
        buf.append(", cmdHandle=");
        buf.append(msgID);
        logger.info(buf.toString());
    }

    static final void logErrCode(String msg, TrapMSGPacket packet) {
        StringBuilder buf = new StringBuilder();
        buf.append(msg).append(packet.toString());
        logger.info(buf.toString());
    }

    private static class ReconnectCloseLock {
        private ReconnectCloseLock() {
        }
    }
}

