/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

import com.huawei.uflight.trapconnector.core.CommStateEvent;
import com.huawei.uflight.trapconnector.core.TrapCommHandle;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reconnector {
    private static Logger logger = LoggerFactory.getLogger(Reconnector.class);
    private static final String PARA_RECCONECT_PROPERTIES_INTERVAL = "interval";
    private static final String PARA_RECCONECT_PROPERTIES_MAXTIMES = "maxtimes";
    public static final int MAX_INTERVAL = 120;
    public static final int MAX_TIMES = 100000;
    public static final int DEFAULT_INTERVAL = 1;
    public static final int DEFAULT_TIMES = 5;
    protected int curInterval = 1;
    private int maxtimes = 5;
    private static final long ONE_SECOND = 1000L;

    public Reconnector(Properties props) {
        String sMaxtimes;
        String sInter = props.getProperty(PARA_RECCONECT_PROPERTIES_INTERVAL);
        if (sInter != null) {
            try {
                this.curInterval = Integer.parseInt(sInter);
                this.curInterval = this.curInterval > 120 || this.curInterval < 1 ? 1 : this.curInterval;
            }
            catch (NumberFormatException e) {
                this.curInterval = 1;
                logger.warn("Reconnector()", (Throwable)e);
            }
        }
        if ((sMaxtimes = props.getProperty(PARA_RECCONECT_PROPERTIES_MAXTIMES)) != null) {
            try {
                this.maxtimes = Integer.parseInt(sMaxtimes);
                this.maxtimes = this.maxtimes > 100000 || this.maxtimes < 1 ? 5 : this.maxtimes;
            }
            catch (NumberFormatException e) {
                this.maxtimes = 5;
                logger.warn("Reconnector()", (Throwable)e);
            }
        }
    }

    public boolean reconnect(TrapCommHandle consumer) {
        int retry = 0;
        try {
            while (!consumer.isClosed()) {
                consumer.stateChanged(CommStateEvent.RECONNECT_RUN);
                ++retry;
                if (consumer.reconnect()) {
                    consumer.stateChanged(CommStateEvent.RECONNECT_SUCCESS);
                    return true;
                }
                consumer.stateChanged(CommStateEvent.RECONNECT_FAILED);
                if (!this.isContinue(retry)) {
                    consumer.stateChanged(CommStateEvent.RECONNECT_ABORT);
                    return false;
                }
                int interval = retry * this.curInterval;
                if (interval > 120) {
                    interval = 120;
                }
                consumer.stateChanged(CommStateEvent.RECONNECT_WAIT);
                Thread.sleep((long)interval * 1000L);
            }
        }
        catch (InterruptedException e) {
            logger.warn("reconnect()", (Throwable)e);
        }
        consumer.stateChanged(CommStateEvent.RECONNECT_EXIT);
        return false;
    }

    protected boolean isContinue(int retrys) {
        return true;
    }
}

