/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

import com.huawei.uflight.trapconnector.core.MSGListener;
import com.huawei.uflight.trapconnector.core.TrapMSGPacket;
import java.util.ArrayList;
import java.util.List;

public class MSGSyncReceiver
implements MSGListener {
    private List<TrapMSGPacket> packets = new ArrayList<TrapMSGPacket>();
    private int flag = 1;

    @Override
    public final boolean receiveMessage(TrapMSGPacket msg) {
        if (null == msg) {
            return false;
        }
        this.packets.add(msg);
        this.notifyReceiver(0);
        return true;
    }

    @Override
    public final void timeout(int cmdCode, int msgID) {
        this.notifyReceiver(-1);
    }

    public final TrapMSGPacket[] getResults() {
        int size = this.packets.size();
        if (size > 0) {
            TrapMSGPacket[] msgs = new TrapMSGPacket[size];
            this.packets.toArray(msgs);
            return msgs;
        }
        return new TrapMSGPacket[0];
    }

    public final TrapMSGPacket getResult() {
        if (!this.packets.isEmpty()) {
            return this.packets.get(0);
        }
        return null;
    }

    public void setFlag(int val) {
        this.flag = val;
    }

    public int getFlag() {
        return this.flag;
    }

    public void reset() {
        this.notifyReceiver(1);
        this.packets.clear();
    }

    final void cancel() {
        if (this.flag != 2) {
            return;
        }
        this.notifyReceiver(3);
        this.packets.clear();
    }

    private synchronized void notifyReceiver(int flag) {
        this.flag = flag;
        this.notifyAll();
    }
}

