/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

import com.huawei.uflight.trapconnector.core.TrapCommHandle;
import com.huawei.uflight.trapconnector.core.TrapMSGPacket;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataAccepter {
    private static Logger logger = LoggerFactory.getLogger(DataAccepter.class);
    private List<TrapMSGPacket> recvBuffer = new ArrayList<TrapMSGPacket>();

    DataAccepter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendToDispatch(TrapMSGPacket packet) {
        TrapCommHandle.logTrace("Receive a msgPacket and add this to recvBuffer.", packet);
        List<TrapMSGPacket> list = this.recvBuffer;
        synchronized (list) {
            this.recvBuffer.add(packet);
            this.recvBuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<TrapMSGPacket> list = this.recvBuffer;
        synchronized (list) {
            this.recvBuffer.clear();
            this.recvBuffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TrapMSGPacket getMessage() {
        if (this.recvBuffer == null) {
            logger.info("<WARNING>DataAccepter.getMessage: recvBuffer is null.");
            return null;
        }
        try {
            List<TrapMSGPacket> list = this.recvBuffer;
            synchronized (list) {
                if (this.recvBuffer.isEmpty()) {
                    this.recvBuffer.wait();
                    if (this.recvBuffer.isEmpty()) {
                        logger.info("DataAccepter recvBuffer.size() is:" + this.recvBuffer.size());
                        return null;
                    }
                }
                return this.recvBuffer.remove(0);
            }
        }
        catch (Exception e) {
            logger.error("MsgDispatcher is interrupted!", (Throwable)e);
            return null;
        }
    }
}

