/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

final class CommUtil {
    private static final int MAX_UNSIGNED_BYTE = 255;
    private static final int INT_BYTES_NUM = 4;
    private static final int ONE_BYTE_BITS = 8;
    private static final int TWO_BYTES_BITS = 16;
    private static final int THREE_BYTES_BITS = 24;

    private CommUtil() {
    }

    public static byte[] intToBytes(int value) {
        byte[] bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        return bytes;
    }

    public static int bytesToInt(byte[] bytes) {
        if (bytes.length != 4) {
            throw new IllegalArgumentException("bytesToInt(): bytes.length != 4");
        }
        int result = 0;
        result = ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
        return result;
    }

    public static interface CmdCode {
        public static final int IFMSCOM_CMD_SHAKE_HAND = 3;
        public static final int IFMSCOM_CMD_INIT_CONNECTION = 4;
        public static final int IFMSCOM_CMD_CONNECTION_FAIL = 12;
        public static final int IFMSCOM_CMD_CONNECTION_SUCCESS = 13;
        public static final int FAULT_CMD_TO_TRAP_RECEIVER_RELOAD = 20;
    }

    public static interface ConnState {
        public static final int IDLE = 1;
        public static final int CONNECTING = 2;
        public static final int CONNECTED = 3;
        public static final int DISCONNECTING = 4;
        public static final int DISCONNECTED = 5;
    }

    public static class MsgType {
        public static final int MSG_REQUEST_NBC = 1;
        public static final int MSG_REQUEST_BC = 2;
        public static final int MSG_ACK = 3;
        public static final int MSG_SHAKEHAND = 4;
        public static final int MSG_INIT_CONNECTION = 5;
    }

    public static class MsgPriority {
        public static final int HIGH = 1;
        public static final int LOW = 2;
    }

    public static interface SendState {
        public static final int SOCKET_ERROR = -3;
        public static final int TIMEOUT = -1;
        public static final int SUCCESS = 0;
        public static final int INITIAL = 1;
        public static final int WAITING = 2;
        public static final int CANCEL = 3;
    }

    public static class CommState {
        public static final byte SOCKET_FAIL = -1;
        public static final byte NOT_REGISTER = -2;
        public static final byte SOCKET_ERROR = -3;
        public static final byte NOT_CONNECT = -3;
        public static final byte NORMAL = 1;
        public static final byte CLOSED = 2;
    }

    public static interface CommNotify {
        public static final char UNCONNECTED = '\u0001';
    }
}

