/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

import com.huawei.uflight.trapconnector.core.TrapMsgDispatcher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommTimeoutChecker
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(CommTimeoutChecker.class);
    private static final int REMOVE_ITEM_FAILED = -1;
    private static final int CHECK_INTERVAL = 1000;
    private static final int ONE_SECOND = 1000;
    private TrapMsgDispatcher dispatcher = null;
    private volatile boolean running = true;
    private Map<Integer, CheckItem> itemMap = new HashMap<Integer, CheckItem>();
    private static final AtomicInteger threadNum = new AtomicInteger(0);

    CommTimeoutChecker(TrapMsgDispatcher disp) {
        this.dispatcher = disp;
        this.setName(this.getClass().getName() + threadNum.getAndIncrement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(int msgID, int cmdCode, int timeout) {
        if (this.itemMap == null) {
            return;
        }
        CheckItem item = new CheckItem();
        item.msgID = msgID;
        item.cmdCode = cmdCode;
        item.timeout = timeout;
        Map<Integer, CheckItem> map = this.itemMap;
        synchronized (map) {
            this.itemMap.put(msgID, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeItem(int msgID) {
        if (this.itemMap == null) {
            return -1;
        }
        CheckItem item = null;
        Map<Integer, CheckItem> map = this.itemMap;
        synchronized (map) {
            item = this.itemMap.remove(msgID);
        }
        if (item == null) {
            return -1;
        }
        return item.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshTimeoutValue(int newValue, int msgID) {
        if (this.itemMap == null) {
            return;
        }
        CheckItem item = null;
        Map<Integer, CheckItem> map = this.itemMap;
        synchronized (map) {
            item = this.itemMap.get(msgID);
        }
        if (item != null && newValue > 0) {
            item.timeout = newValue * 1000;
            logger.info("Refresh timeout value, cmdHandle=" + msgID + ", newValue=" + newValue);
        } else {
            if (item == null) {
                logger.error("CommTimeoutChecker refreshTimeoutValue failed: CheckItem is null, cmdHandle=" + msgID);
            }
            if (newValue <= 0) {
                logger.error("CommTimeoutChecker refreshTimeoutValue failed: newValue=" + newValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                Object object = this;
                synchronized (object) {
                    this.wait(1000L);
                }
                object = this.itemMap;
                synchronized (object) {
                    if (!this.itemMap.isEmpty()) {
                        Iterator<CheckItem> list = this.itemMap.values().iterator();
                        CheckItem item = null;
                        boolean isTimeout = false;
                        while (list.hasNext()) {
                            item = list.next();
                            ++item.count;
                            if (item.count * 1000 < item.timeout + 1000) continue;
                            isTimeout = this.dispatcher.checkTimeout(item.msgID);
                            if (isTimeout) {
                                this.dispatcher.timeout(item.cmdCode, item.msgID);
                                list.remove();
                                continue;
                            }
                            item.count = 0;
                        }
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            logger.error("error", (Throwable)ex);
        }
        this.dispatcher = null;
        this.itemMap.clear();
        logger.info("CommTimeoutChecker exited!");
    }

    public void close() {
        this.running = false;
        this.interrupt();
    }

    private static class CheckItem {
        int msgID;
        int cmdCode;
        int timeout;
        int count = 0;

        private CheckItem() {
        }
    }
}

