/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector.core;

import com.huawei.uflight.trapconnector.core.DataAccepter;
import com.huawei.uflight.trapconnector.core.TrapCommHandle;
import com.huawei.uflight.trapconnector.core.TrapMSGHead;
import com.huawei.uflight.trapconnector.core.TrapMSGPacket;
import java.io.BufferedInputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommReader
extends Thread {
    private Logger logger = LoggerFactory.getLogger(CommReader.class);
    private static final int DEFAULT_BUF_LEN = 66560;
    private static final int UPPER_LIMIT_BUF_LEN = 0x400000;
    private TrapCommHandle m_Handle = null;
    private BufferedInputStream in = null;
    private DataAccepter m_Accepter = null;
    private byte[] byteBuffer = new byte[66560];
    private boolean normalClose = false;
    private static final AtomicInteger threadNum = new AtomicInteger(0);

    CommReader(TrapCommHandle handle, BufferedInputStream input, DataAccepter accepter) {
        this.m_Handle = handle;
        this.in = input;
        this.m_Accepter = accepter;
        this.setName(this.getClass().getName() + threadNum.getAndIncrement());
    }

    void setAccepter(DataAccepter accepter) {
        this.m_Accepter = accepter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TrapMSGHead head = null;
        boolean readHead = true;
        int readLength = 36;
        int contentLength = 0;
        int bufPos = 0;
        try {
            while (true) {
                int len;
                if ((len = this.in.read(this.byteBuffer, bufPos, readLength)) <= 0) {
                    this.logger.error("|CommReader|run()|Read Error, len=" + len);
                    break;
                }
                if (len < readLength) {
                    readLength -= len;
                    bufPos += len;
                    continue;
                }
                bufPos = 0;
                if (readHead) {
                    head = new TrapMSGHead();
                    head.fromByte(this.byteBuffer);
                    TrapCommHandle.logTrace("From socket;", head);
                    contentLength = head.getContentLen();
                    if (contentLength > 0) {
                        readHead = false;
                        readLength = contentLength;
                        if (this.byteBuffer == null || contentLength <= this.byteBuffer.length) continue;
                        this.byteBuffer = new byte[contentLength];
                        continue;
                    }
                }
                if (this.m_Accepter != null) {
                    TrapMSGPacket packet = new TrapMSGPacket(head, this.byteBuffer, contentLength);
                    this.m_Accepter.sendToDispatch(packet);
                }
                if (this.byteBuffer.length > 0x400000) {
                    this.byteBuffer = new byte[66560];
                }
                readHead = true;
                readLength = 36;
                contentLength = 0;
            }
        }
        catch (Exception exp) {
            if (!this.normalClose) {
                this.logger.error("error", (Throwable)exp);
            }
        }
        finally {
            this.abort();
        }
        this.m_Accepter = null;
        this.in = null;
        this.byteBuffer = null;
        this.m_Handle = null;
        this.logger.info("CommReader exited");
    }

    private void abort() {
        this.logger.error("come in abort normalClose = " + this.normalClose);
        if (!this.normalClose) {
            this.logger.error("come in abort");
            this.normalClose = true;
            this.m_Handle.handleError();
        }
    }

    void close() {
        this.normalClose = true;
    }
}

