/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.trapconnector;

import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.uflight.communicate.util.CommunicateUtil;
import com.huawei.uflight.trapconnector.ITrapMsgListener;
import com.huawei.uflight.trapconnector.TrapReceiverBindInfo;
import com.huawei.uflight.trapconnector.TrapReceiverInfo;
import com.huawei.uflight.trapconnector.asn.AsnCltToSvrGetSnmpDevTrapReceiverBindReq;
import com.huawei.uflight.trapconnector.asn.AsnCltToSvrGetTrapServerReq;
import com.huawei.uflight.trapconnector.asn.AsnCltToSvrGetTrapServerResp;
import com.huawei.uflight.trapconnector.asn.AsnCltToSvrSetSnmpDevTrapReceiverBindReq;
import com.huawei.uflight.trapconnector.asn.AsnCltToSvrSnmpDevTrapReceiverBind;
import com.huawei.uflight.trapconnector.asn.AsnSendTrapStrc;
import com.huawei.uflight.trapconnector.asn.AsnSvrToCltSnmpDevTrapReceiverBind;
import com.huawei.uflight.trapconnector.asn.AsnSvrToCltSnmpDevTrapReceiverBindResp;
import com.huawei.uflight.trapconnector.asn.AsnTrapServerState;
import com.huawei.uflight.trapconnector.asn.AsniFMSError;
import com.huawei.uflight.trapconnector.core.TrapCommHandle;
import com.huawei.uflight.trapconnector.core.TrapMSGPacket;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrapCommManager
implements ITrapMsgListener {
    private static Logger logger = LoggerFactory.getLogger(TrapCommManager.class);
    private static Map<Character, Map<TrapReceiverInfo, TrapCommHandle>> connectionMap = new Hashtable<Character, Map<TrapReceiverInfo, TrapCommHandle>>();
    private static Map<Character, TrapCommManager> instancesMap = new Hashtable<Character, TrapCommManager>();
    private Map<Integer, Vector<ITrapMsgListener>> listernerTable = new Hashtable<Integer, Vector<ITrapMsgListener>>();
    private ProcessInfo procInfo;

    private TrapCommManager(ProcessInfo procInfo) {
        this.procInfo = procInfo;
        this.addMessageListener(2256, this);
    }

    public static TrapCommManager getInstance(String appName) {
        ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
        return TrapCommManager.getInstance(procInfo);
    }

    public static TrapCommManager getInstance(ProcessInfo procInfo) {
        if (null == procInfo) {
            logger.error("The processInfo is null! ");
            return null;
        }
        TrapCommManager instance = instancesMap.get(procInfo.getProcID());
        if (null == instance) {
            instance = new TrapCommManager(procInfo);
            instancesMap.put(procInfo.getProcID(), instance);
        }
        return instance;
    }

    public int startClient(List<TrapReceiverInfo> trapSvrInfos) {
        if (null == trapSvrInfos || trapSvrInfos.isEmpty()) {
            logger.warn("Not fount trap server!");
            return -1;
        }
        for (TrapReceiverInfo trapSvrInfo : trapSvrInfos) {
            this.addTrapConnector(trapSvrInfo);
        }
        return 0;
    }

    public int stopClient() {
        Map<TrapReceiverInfo, TrapCommHandle> handleMap = connectionMap.remove(this.procInfo.getProcID());
        if (null != handleMap) {
            Collection<TrapCommHandle> commHandles = handleMap.values();
            for (TrapCommHandle commHandle : commHandles) {
                commHandle.close();
                commHandles = null;
            }
            handleMap.clear();
        }
        return 0;
    }

    public int addTrapConnector(TrapReceiverInfo trapSvrInfo) {
        Map<TrapReceiverInfo, TrapCommHandle> handleMap = connectionMap.get(this.procInfo.getProcID());
        if (null == handleMap) {
            handleMap = new HashMap<TrapReceiverInfo, TrapCommHandle>();
            connectionMap.put(this.procInfo.getProcID(), handleMap);
        }
        if (handleMap.containsKey(trapSvrInfo)) {
            logger.info("The trapreceiver connector has been exist, trapreceiver info:" + trapSvrInfo.toString());
            return -1;
        }
        TrapCommHandle commHandle = new TrapCommHandle();
        handleMap.put(trapSvrInfo, commHandle);
        try {
            commHandle.connect(trapSvrInfo, this.procInfo.getProcID().charValue());
        }
        catch (Exception e) {
            logger.error("Connect trapreceiver fail, trapreceiver info:" + trapSvrInfo.toString(), (Throwable)e);
        }
        return 0;
    }

    public int removeTrapConnector(TrapReceiverInfo trapSvrInfo) {
        Map<TrapReceiverInfo, TrapCommHandle> handleMap = connectionMap.remove(this.procInfo.getProcID());
        if (null == handleMap || !handleMap.containsKey(trapSvrInfo)) {
            logger.info("The trapreceiver connector not exist, trapreceiver info:" + trapSvrInfo.toString());
            return -1;
        }
        TrapCommHandle commHandle = handleMap.remove(trapSvrInfo);
        if (null != commHandle) {
            commHandle.close();
        }
        return 0;
    }

    public static int getTrapSvrInfos(List<TrapReceiverInfo> trapSrvInfos) {
        AsnCltToSvrGetTrapServerReq req = new AsnCltToSvrGetTrapServerReq();
        req.iUserID = 100;
        AsnCltToSvrGetTrapServerResp rsp = new AsnCltToSvrGetTrapServerResp();
        int result = MsgProxy.getProxyService((ProcessInfo)ConnectManager.getDefaultProcessInfo()).sendMessage(TrapCommManager.getMsgHead(2167), (FStruct)req, (FStruct)rsp);
        if (result != 0) {
            logger.error("getTrapSvrInfos() failed, result = " + result);
            return result;
        }
        int bigErrorCode = rsp.errorCode.lError.intValue();
        if (bigErrorCode != 0) {
            logger.error("getTrapSvrInfos() failed, result = " + result);
            return bigErrorCode;
        }
        AsnTrapServerState pAsnServerInfo = null;
        Iterator trapServerStatItr = rsp.lstTrapServerState.iterator();
        TrapReceiverInfo srvInfo = null;
        while (trapServerStatItr.hasNext()) {
            srvInfo = new TrapReceiverInfo();
            pAsnServerInfo = (AsnTrapServerState)trapServerStatItr.next();
            srvInfo.setCServerIP(new String(pAsnServerInfo.sTrapServer.strServerIP));
            srvInfo.setCServerName(new String(pAsnServerInfo.sTrapServer.strServerName));
            srvInfo.setCServerNotes(new String(pAsnServerInfo.sTrapServer.strServerNotes));
            srvInfo.setIDefaultFlag(pAsnServerInfo.sTrapServer.lDefaultFlag.intValue());
            srvInfo.setIRunFlag(pAsnServerInfo.sTrapServer.lRunFlag.intValue());
            srvInfo.setIServerID(pAsnServerInfo.sTrapServer.lServerID.intValue());
            srvInfo.setIServerLstPort(pAsnServerInfo.sTrapServer.lListenPort.intValue());
            srvInfo.setIServerUdpPort(pAsnServerInfo.sTrapServer.lServerUdpPort.intValue());
            srvInfo.setIRunStatus(pAsnServerInfo.lState.intValue());
            trapSrvInfos.add(srvInfo);
        }
        return 0;
    }

    public static int getTrapReceiverBindMap(int userID, List<TrapReceiverBindInfo> bindInfos) {
        AsnCltToSvrGetSnmpDevTrapReceiverBindReq req = new AsnCltToSvrGetSnmpDevTrapReceiverBindReq();
        req.iUserID = BigInteger.valueOf(userID);
        AsnSvrToCltSnmpDevTrapReceiverBindResp rsp = new AsnSvrToCltSnmpDevTrapReceiverBindResp();
        int result = MsgProxy.getProxyService((ProcessInfo)ConnectManager.getDefaultProcessInfo()).sendMessage(TrapCommManager.getMsgHead(2170), (FStruct)req, (FStruct)rsp);
        if (result == 0) {
            result = rsp.errorCode.lError.intValue();
        }
        if (result != 0) {
            logger.info("getTrapReciverBindMap() fail, errorCode = " + result);
            return result;
        }
        int size = rsp.lstItem.size();
        for (int i = 0; i < size; ++i) {
            AsnSvrToCltSnmpDevTrapReceiverBind asnBind = (AsnSvrToCltSnmpDevTrapReceiverBind)rsp.lstItem.get(i);
            bindInfos.add(new TrapReceiverBindInfo(asnBind.lSnmpDevID.intValue(), asnBind.lTrapReceiverID.intValue()));
        }
        return result;
    }

    public static int setTrapReceiverBindMap(int userID, List<TrapReceiverBindInfo> bindInfos) {
        if (null == bindInfos || bindInfos.isEmpty()) {
            logger.info("Not found trapreceiver bind info.");
            return 0;
        }
        AsnCltToSvrSetSnmpDevTrapReceiverBindReq req = new AsnCltToSvrSetSnmpDevTrapReceiverBindReq();
        req.iUserID = userID;
        for (TrapReceiverBindInfo bindInfo : bindInfos) {
            AsnCltToSvrSnmpDevTrapReceiverBind asnBind = new AsnCltToSvrSnmpDevTrapReceiverBind();
            asnBind.lSnmpDevID = BigInteger.valueOf(bindInfo.getNeid());
            asnBind.lTrapReceiverID = BigInteger.valueOf(bindInfo.getTrapReceiverID());
            req.lstItem.add(asnBind);
        }
        AsniFMSError rsp = new AsniFMSError();
        int result = MsgProxy.getProxyService((ProcessInfo)ConnectManager.getDefaultProcessInfo()).sendMessage(TrapCommManager.getMsgHead(2171), (FStruct)req, (FStruct)rsp);
        if (result != 0) {
            return result;
        }
        return rsp.lError.intValue();
    }

    private static MSGHead getMsgHead(int cmdID) {
        MSGHead head = MSGHeadBuilder.buildMSGHead((int)cmdID, (ProcessInfo)new ProcessInfo(Character.valueOf('8'), Character.valueOf('\u0000')), (byte)4, (char)'\u0000');
        return head;
    }

    public void addMessageListener(int cmdCode, ITrapMsgListener listener) {
        Vector<ITrapMsgListener> listeners = this.listernerTable.get(cmdCode);
        if (listeners == null) {
            listeners = new Vector();
            listeners.addElement(listener);
            this.listernerTable.put(cmdCode, listeners);
        } else if (!listeners.contains(listener)) {
            listeners.addElement(listener);
        }
    }

    public void removeMessageListener(int cmdCode, ITrapMsgListener listener) {
        Vector<ITrapMsgListener> listeners = this.listernerTable.get(cmdCode);
        if (listeners != null) {
            listeners.removeElement(listener);
            if (listeners.isEmpty()) {
                this.listernerTable.remove(cmdCode);
            }
        }
    }

    public void removeMessageListener(int cmdCode) {
        Vector<ITrapMsgListener> listeners = this.listernerTable.get(cmdCode);
        if (listeners != null) {
            listeners.removeAllElements();
            this.listernerTable.remove(cmdCode);
        }
    }

    public List<ITrapMsgListener> getListener(int cmdCode) {
        return this.listernerTable.get(cmdCode);
    }

    @Override
    public void processMessage(TrapMSGPacket msg) {
        AsnSendTrapStrc sendTrapStrc = new AsnSendTrapStrc();
        if (!AsnCoder.deserialize((byte[])msg.getData(), (FStruct)sendTrapStrc)) {
            logger.error("TrapMsgPacket decode error.");
            return;
        }
        MSGHead head = new MSGHead();
        head.cmdCode = msg.getCmdCode();
        head.contentLength = msg.getMheader().getContentLen();
        head.senderProcIP = msg.getMheader().getSendIP();
        head.senderProcID = (char)msg.getMheader().getSendProcID();
        head.receiverModule = sendTrapStrc.ulRecvModuleID.byteValue();
        MSGPacketExt msgPacketExt = new MSGPacketExt(head, msg.getData(), msg.getMheader().getContentLen());
        TaskDispatcherMgr.getInstance((ProcessInfo)this.procInfo).receiveMessage(msgPacketExt);
    }

    public int notifyReloadBC(String condition) {
        int ret = 0;
        Map<TrapReceiverInfo, TrapCommHandle> handleMap = connectionMap.remove(this.procInfo.getProcID());
        if (null == handleMap) {
            logger.warn("The application not connect trapreceiver, the procInfo=" + this.procInfo);
            return ret;
        }
        Collection<TrapCommHandle> commHandles = handleMap.values();
        for (TrapCommHandle commHandle : commHandles) {
            ret = commHandle.notifyReloadNBC(condition);
        }
        return ret;
    }

    public static void removeTrapComm(String appName) {
        ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
        if (null == procInfo) {
            logger.info("The processInfo is null, skip remove trap communication. ");
            return;
        }
        TrapCommManager commMgr = instancesMap.remove(procInfo.getProcID());
        if (null != commMgr) {
            commMgr.stopClient();
            commMgr = null;
        }
    }
}

