/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.communicate.util;

import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.IntegratedAppEntity;
import com.huawei.uflight.communicate.osgi.CommunicateActivator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommunicateUtil {
    private static final String IMAP_CONFIG_PATH_ENV = "IMAP_CONFIG_PATH";
    private static final String IMAP_ROOT_ENV = "IMAP_ROOT";
    private static final String OPTION_FILE_NAME = "option.xml";
    private static Logger log = LoggerFactory.getLogger(CommunicateUtil.class);

    private CommunicateUtil() {
    }

    public static String getAppPathByAppName(String appName) {
        AppEntity appEntity = CommunicateActivator.getAppMgr().getAppByName(appName);
        if (null == appEntity || AppEntity.AppState.undeployed == appEntity.getState()) {
            log.warn("The application not deploy, appName = " + appName);
            return null;
        }
        return appEntity.getAppPath();
    }

    public static ProcessInfo getProcInfoByAppName(String appName) {
        ProcessInfo procInfo = new ProcessInfo();
        IntegratedAppEntity appEntity = (IntegratedAppEntity)CommunicateActivator.getAppMgr().getAppByName(appName);
        if (null == appEntity || AppEntity.AppState.undeployed == appEntity.getState()) {
            log.warn("The application not deploy, appName = " + appName);
            return null;
        }
        if (-1 == appEntity.getProcID() || -1 == appEntity.getProcHandle()) {
            log.warn("The application not config the processInfo, appName = " + appName);
            return null;
        }
        procInfo.setProcID((char)appEntity.getProcID());
        procInfo.setProcHandle((char)appEntity.getProcHandle());
        return procInfo;
    }

    public static Properties getMDPProperties() {
        Properties mdpProperties = new Properties();
        Properties imapPro = CommunicateUtil.getIMapProperties();
        if (null != imapPro) {
            mdpProperties.put("MDPIP", imapPro.getProperty("MDPAddress"));
            mdpProperties.put("MDPPort", imapPro.getProperty("MDPTrustPort"));
            mdpProperties.put("MDPSSLPort", imapPro.getProperty("MDPSSLPort"));
        }
        return mdpProperties;
    }

    public static Properties getProcessPro(String appName) {
        Properties processPro = new Properties();
        ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
        if (null == procInfo) {
            return null;
        }
        processPro.put("ProcID", "" + procInfo.getProcID().charValue());
        processPro.put("ProcHandle", "" + procInfo.getProcHandle().charValue());
        return processPro;
    }

    public static Properties getCommProperties() {
        Properties processPro = new Properties();
        Properties imapSecPro = CommunicateUtil.getIMapProperties();
        processPro.put("SSLMode", imapSecPro.getProperty("SSLMode"));
        String imapRootEnv = System.getenv(IMAP_ROOT_ENV);
        String filePath = imapRootEnv + File.separatorChar + "etc" + File.separatorChar + "ssl";
        processPro.put("SSLCertFilePath", filePath);
        processPro.put("SSLOptionFileName", OPTION_FILE_NAME);
        return processPro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getIMapProperties() {
        String imapEnv = System.getenv(IMAP_CONFIG_PATH_ENV);
        String imapFileName = "imap.cfg";
        String imapPath = imapEnv + File.separator + imapFileName;
        log.info("imap.cfg = " + imapPath);
        Properties imapPro = new Properties();
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(imapPath);
            imapPro.load(stream);
        }
        catch (FileNotFoundException e) {
            log.error("File not found.", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Load stream fail.", (Throwable)e);
        }
        finally {
            try {
                if (null != stream) {
                    stream.close();
                }
            }
            catch (IOException e) {
                log.error("Close Stream Fail!", (Throwable)e);
            }
        }
        return imapPro;
    }
}

