/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.uflight.communicate.osgi;

import com.huawei.commextend.dbbackupblockapp.DBBackupFrame;
import com.huawei.commextend.dbpool.DBConfiguration;
import com.huawei.commextend.eventmgr.EventUtil;
import com.huawei.commextend.frameutil.DBInfoQuery;
import com.huawei.commextend.reliableevent.ReliableEventProxy;
import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.communicate.core.Configuration;
import com.huawei.communicate.core.ConnectManager;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.communicate.proxy.IProxyService;
import com.huawei.communicate.proxy.MSGHeadBuilder;
import com.huawei.communicate.proxy.MsgProxy;
import com.huawei.communicate.util.receive.ILiteReceiver;
import com.huawei.uflight.appmanager.api.AppEntity;
import com.huawei.uflight.appmanager.api.IAppStateChanageListener;
import com.huawei.uflight.communicate.util.CommunicateUtil;
import com.huawei.uflight.trapconnector.TrapCommManager;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppStateChangeListerner
implements IAppStateChanageListener,
BundleListener {
    private static final int START_PROCESS_CMD = 2;
    private static final int STOP_PROCESS_CMD = 1;
    private static final String TASKMGR_DES_FILENAME = "conf/taskmgr.xml";
    private static final String APP_MGR_BUNDLE_SYMBOCNAME = "com.huawei.uflight.appmanager";
    private static Logger log = LoggerFactory.getLogger(AppStateChangeListerner.class);
    private ILiteReceiver processMoniReceiver = new ProcessMoniReceiver();
    private volatile boolean isStarted = false;
    private volatile boolean isDbInit = false;

    public void preStateChanged(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
        String appName = app.getAppName();
        if (newState == AppEntity.AppState.started) {
            boolean isDefault = "FRAME_APP".equalsIgnoreCase(appName);
            this.initAppCommunicate(appName, isDefault);
            this.initTaskMgr(appName);
            this.interruptReliableEventRcv(appName);
        }
    }

    public void postStateChanged(AppEntity app, AppEntity.AppState oldState, AppEntity.AppState newState) {
        String appName = app.getAppName();
        if (newState == AppEntity.AppState.stoped) {
            this.removeTaskMgr(appName);
            this.removeEventProxy(appName);
            this.removeReliableEventProxy(appName);
            this.removeDBBackupFrame(appName);
            this.removeAppCommunicate(appName);
        } else {
            this.resumeReliableEventRcv(appName);
        }
    }

    private void initAppCommunicate(String appName, boolean isDefault) {
        block5: {
            log.info("start init the application communicate, the appName = " + appName);
            try {
                Properties properties = CommunicateUtil.getProcessPro(appName);
                if (null == properties) {
                    log.warn("The application not configrate process information, skip init communicate.the appName=" + appName);
                    return;
                }
                properties.putAll((Map<?, ?>)CommunicateUtil.getMDPProperties());
                properties.putAll((Map<?, ?>)CommunicateUtil.getCommProperties());
                Configuration.getInstance().configure(properties, new boolean[]{isDefault});
                IProxyService service = MsgProxy.getProxyService((ProcessInfo)CommunicateUtil.getProcInfoByAppName(appName));
                service.addMessageListener(2, this.processMoniReceiver);
                service.addMessageListener(1, this.processMoniReceiver);
                if (this.isDbInit) break block5;
                try {
                    this.initDbProperties();
                }
                catch (Exception e) {
                    log.error("initDBConf fail!", (Throwable)e);
                }
                this.isDbInit = true;
            }
            catch (Exception e) {
                log.error("initAppCommunicate Fail.", (Throwable)e);
            }
        }
    }

    private void initDbProperties() {
        String dbName = "MCDB";
        DBConfiguration.getInstance().initDBConf(DBInfoQuery.getDBProperties((String)dbName));
    }

    private void initTaskMgr(String appName) {
        try {
            ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
            if (null == procInfo) {
                log.warn("The application not configrate process information, skip init taskMgr, the appName = " + appName);
                return;
            }
            String configFilePath = CommunicateUtil.getAppPathByAppName(appName) + File.separator + TASKMGR_DES_FILENAME;
            File file = new File(configFilePath);
            if (file.exists()) {
                TaskDispatcherMgr instance = TaskDispatcherMgr.getInstance((ProcessInfo)procInfo);
                instance.init(configFilePath);
            } else {
                log.warn("The application not configrate taskmgr information, skip init taskMgr, the appName = " + appName + ",taskmgrConfigFilePath=" + configFilePath);
            }
        }
        catch (Exception e) {
            log.error("initTaskMgr Fail.", (Throwable)e);
        }
    }

    private void removeTaskMgr(String appName) {
        try {
            ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
            if (null == procInfo) {
                log.warn("The application not configrate process information, skip remove taskMgr, the appName = " + appName);
                return;
            }
            TaskDispatcherMgr.removeTaskMgr((ProcessInfo)procInfo);
        }
        catch (Exception e) {
            log.error("removeTaskMgr Fail.", (Throwable)e);
        }
    }

    private void removeAppCommunicate(String appName) {
        log.info("start remove the application communicate, the appName = " + appName);
        try {
            TrapCommManager.removeTrapComm(appName);
            ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
            MsgProxy.removeProxyService((ProcessInfo)procInfo);
            MsgProxy.removeServiceAdapter((ProcessInfo)procInfo);
        }
        catch (Exception e) {
            log.error("removeAppCommunicate Fail.", (Throwable)e);
        }
    }

    private void removeEventProxy(String appName) {
        try {
            ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
            if (null == procInfo) {
                log.warn("The application not configrate process information, skip remove EventProxy, the appName = " + appName);
                return;
            }
            EventUtil.removeEventProxy((ProcessInfo)procInfo);
        }
        catch (Exception e) {
            log.error("removeEventProxy Fail.", (Throwable)e);
        }
    }

    private void removeReliableEventProxy(String appName) {
        try {
            ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
            if (null == procInfo) {
                log.warn("The application not configrate process information, skip remove ReliableEventProxy, the appName = " + appName);
                return;
            }
            ReliableEventProxy.removeEventProxy((ProcessInfo)procInfo);
        }
        catch (Exception e) {
            log.error("removeReliableEventProxy Fail.", (Throwable)e);
        }
    }

    private void removeDBBackupFrame(String appName) {
        try {
            ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
            if (null == procInfo) {
                log.warn("The application not configrate process information, skip remove DBBackupFrame, the appName = " + appName);
                return;
            }
            DBBackupFrame.removeDBBackupFrame((ProcessInfo)procInfo);
        }
        catch (Exception e) {
            log.error("removeDBBackupFrame Fail.", (Throwable)e);
        }
    }

    private void interruptReliableEventRcv(String appName) {
        try {
            ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
            if (null == procInfo) {
                log.warn("The application not configrate process information, skip interrupt ReliableEventProxy, the appName = " + appName);
                return;
            }
            ReliableEventProxy.getInstance((ProcessInfo)procInfo).interruptEventRcv();
        }
        catch (Exception e) {
            log.error("initReliableEventProxy Fail.", (Throwable)e);
        }
    }

    private void resumeReliableEventRcv(String appName) {
        try {
            ProcessInfo procInfo = CommunicateUtil.getProcInfoByAppName(appName);
            if (null == procInfo) {
                log.warn("The application not configrate process information, skip resume ReliableEventProxy, the appName = " + appName);
                return;
            }
            ReliableEventProxy.getInstance((ProcessInfo)procInfo).resumeEventRcv();
        }
        catch (Exception e) {
            log.error("initReliableEventProxy Fail.", (Throwable)e);
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        Bundle bundle = bundleEvent.getBundle();
        if (this.isAppManagerBundle(bundle) && 32 == bundle.getState()) {
            this.isStarted = true;
        }
    }

    private boolean isAppManagerBundle(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        return APP_MGR_BUNDLE_SYMBOCNAME.equals(symbolicName);
    }

    class ProcessMoniReceiver
    implements ILiteReceiver {
        ProcessMoniReceiver() {
        }

        public boolean receiveMessage(MSGPacketExt packet) {
            log.info("ProcessReceiver:" + packet);
            if (2 == packet.getCmdCode()) {
                if (!AppStateChangeListerner.this.isStarted) {
                    return true;
                }
                MsgProxy.getProxyService((ProcessInfo)ConnectManager.getDefaultProcessInfo()).sendResponseMessage(MSGHeadBuilder.convertToResoponseMSGHead((MSGHead)packet.mheader), null);
            } else {
                log.warn("Stop uflight process from sysmonitor!");
                System.exit(0);
            }
            return true;
        }

        public void timeout(int cmdCode, Character cmdHandle) {
        }
    }
}

