/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.sdhneinterface;

import com.huawei.network.qasn.m_q_common.QAsnNEIDList;
import com.huawei.network.qasn.sdhneinterface.QAsnPSNCircle;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnPSNInfo
implements FStruct {
    public int psnID = -1;
    public byte[] nativeEMSName = null;
    public byte[] userLabel = null;
    public byte[] owner;
    public int level = -1;
    public int psnType = -1;
    public QAsnNEIDList neIDList = new QAsnNEIDList();
    public QAsnPSNCircle psnLinks = new QAsnPSNCircle();

    public QAsnPSNInfo() {
    }

    public QAsnPSNInfo(QAsnPSNInfo arg) {
        this.psnID = arg.psnID;
        if (arg.nativeEMSName != null) {
            this.nativeEMSName = new byte[arg.nativeEMSName.length];
            System.arraycopy(arg.nativeEMSName, 0, this.nativeEMSName, 0, arg.nativeEMSName.length);
        }
        if (arg.userLabel != null) {
            this.userLabel = new byte[arg.userLabel.length];
            System.arraycopy(arg.userLabel, 0, this.userLabel, 0, arg.userLabel.length);
        }
        this.owner = new byte[arg.owner.length];
        System.arraycopy(arg.owner, 0, this.owner, 0, arg.owner.length);
        this.level = arg.level;
        this.psnType = arg.psnType;
        this.neIDList = new QAsnNEIDList(arg.neIDList);
        this.psnLinks = new QAsnPSNCircle(arg.psnLinks);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.psnID));
        if (this.nativeEMSName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.nativeEMSName);
        }
        if (this.userLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.userLabel);
        }
        enc.serializeOctetString(this.owner);
        enc.serializeInteger(BigInteger.valueOf(this.level));
        enc.serializeInteger(BigInteger.valueOf(this.psnType));
        this.neIDList.serialize(enc);
        this.psnLinks.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.psnID = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.nativeEMSName = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.userLabel = dec.deserializeOctetString();
        }
        this.owner = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.level = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.psnType = bi.intValue();
        }
        this.neIDList.deserialize(dec);
        this.psnLinks.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("psnID = ");
        os.print(this.psnID);
        os.println(',');
        if (this.nativeEMSName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("nativeEMSName = ");
            os.print(FStruFormat.convertToString((byte[])this.nativeEMSName));
            os.println(',');
        }
        if (this.userLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("userLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.userLabel));
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("owner = ");
        os.print(FStruFormat.convertToString((byte[])this.owner));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("level = ");
        os.print(this.level);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("psnType = ");
        os.print(this.psnType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neIDList = ");
        this.neIDList.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("psnLinks = ");
        this.psnLinks.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

