/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.qnmlasoncommon;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnAsonNodeInfo
implements FStruct {
    public BigInteger nodeID;
    public BigInteger nodeType;
    public BigInteger nodeVersion;
    public int nodeRealNeID = -1;
    public BigInteger nodeRealNeType;
    public byte[] nodeNeName;

    public QAsnAsonNodeInfo() {
    }

    public QAsnAsonNodeInfo(QAsnAsonNodeInfo arg) {
        this.nodeID = arg.nodeID;
        this.nodeType = arg.nodeType;
        this.nodeVersion = arg.nodeVersion;
        this.nodeRealNeID = arg.nodeRealNeID;
        this.nodeRealNeType = arg.nodeRealNeType;
        this.nodeNeName = new byte[arg.nodeNeName.length];
        System.arraycopy(arg.nodeNeName, 0, this.nodeNeName, 0, arg.nodeNeName.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.nodeID);
        enc.serializeInteger(this.nodeType);
        enc.serializeInteger(this.nodeVersion);
        enc.serializeInteger(BigInteger.valueOf(this.nodeRealNeID));
        enc.serializeInteger(this.nodeRealNeType);
        enc.serializeOctetString(this.nodeNeName);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.nodeID = dec.deserializeInteger();
        this.nodeType = dec.deserializeInteger();
        this.nodeVersion = dec.deserializeInteger();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.nodeRealNeID = bi.intValue();
        }
        this.nodeRealNeType = dec.deserializeInteger();
        this.nodeNeName = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nodeID = ");
        os.print(this.nodeID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nodeType = ");
        os.print(this.nodeType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nodeVersion = ");
        os.print(this.nodeVersion.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nodeRealNeID = ");
        os.print(this.nodeRealNeID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nodeRealNeType = ");
        os.print(this.nodeRealNeType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nodeNeName = ");
        os.print(FStruFormat.convertToString((byte[])this.nodeNeName));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

