/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.qasntrailcommon;

import com.huawei.network.qasn.qasntrailcommon.QAsnPortPair;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnTrailToL2Link
implements FStruct {
    public QAsnPortPair portPair = new QAsnPortPair();
    public BigInteger trailLevel;
    public byte[] trailUniqueID;

    public QAsnTrailToL2Link() {
    }

    public QAsnTrailToL2Link(QAsnTrailToL2Link arg) {
        this.portPair = new QAsnPortPair(arg.portPair);
        this.trailLevel = arg.trailLevel;
        this.trailUniqueID = new byte[arg.trailUniqueID.length];
        System.arraycopy(arg.trailUniqueID, 0, this.trailUniqueID, 0, arg.trailUniqueID.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.portPair.serialize(enc);
        enc.serializeInteger(this.trailLevel);
        enc.serializeOctetString(this.trailUniqueID);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.portPair.deserialize(dec);
        this.trailLevel = dec.deserializeInteger();
        this.trailUniqueID = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portPair = ");
        this.portPair.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trailLevel = ");
        os.print(this.trailLevel.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trailUniqueID = ");
        os.print(FStruFormat.convertToString((byte[])this.trailUniqueID));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

