/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.qasntrailcommon;

import com.huawei.network.qasn.m_q_common.QAsnNEIDList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnComNeInTrail
implements FStruct {
    public int clientTrailOID = -1;
    public byte[] serverTrailName;
    public QAsnNEIDList comNEIDList = new QAsnNEIDList();

    public QAsnComNeInTrail() {
    }

    public QAsnComNeInTrail(QAsnComNeInTrail arg) {
        this.clientTrailOID = arg.clientTrailOID;
        this.serverTrailName = new byte[arg.serverTrailName.length];
        System.arraycopy(arg.serverTrailName, 0, this.serverTrailName, 0, arg.serverTrailName.length);
        this.comNEIDList = new QAsnNEIDList(arg.comNEIDList);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.clientTrailOID));
        enc.serializeOctetString(this.serverTrailName);
        this.comNEIDList.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.clientTrailOID = bi.intValue();
        }
        this.serverTrailName = dec.deserializeOctetString();
        this.comNEIDList.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("clientTrailOID = ");
        os.print(this.clientTrailOID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("serverTrailName = ");
        os.print(FStruFormat.convertToString((byte[])this.serverTrailName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("comNEIDList = ");
        this.comNEIDList.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

