/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.qasntrailcommon;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnResLinkInfo
implements FStruct {
    public int leftObjID = -1;
    public int rightObjID = -1;
    public Integer linkType = null;
    public byte[] linkID = null;

    public AsnResLinkInfo() {
    }

    public AsnResLinkInfo(AsnResLinkInfo arg) {
        this.leftObjID = arg.leftObjID;
        this.rightObjID = arg.rightObjID;
        if (arg.linkType != null) {
            this.linkType = arg.linkType;
        }
        if (arg.linkID != null) {
            this.linkID = new byte[arg.linkID.length];
            System.arraycopy(arg.linkID, 0, this.linkID, 0, arg.linkID.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.leftObjID));
        enc.serializeInteger(BigInteger.valueOf(this.rightObjID));
        if (this.linkType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.linkType.intValue()));
        }
        if (this.linkID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.linkID);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.leftObjID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.rightObjID = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.linkType = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.linkType = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.linkID = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("leftObjID = ");
        os.print(this.leftObjID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("rightObjID = ");
        os.print(this.rightObjID);
        os.println(',');
        if (this.linkType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("linkType = ");
            os.print(this.linkType.toString());
            os.println(',');
        }
        if (this.linkID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("linkID = ");
            os.print(FStruFormat.convertToString((byte[])this.linkID));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

