/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.q_tools_xftp;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnXFTPConfigInfo
implements FStruct {
    public int ixFtptype = -1;
    public int iState = -1;
    public byte[] strUserName;
    public byte[] strPassword;
    public byte[] strPath;
    public byte[] strIPAdress;
    public int iPort = -1;
    public Integer iLocation = null;

    public QAsnXFTPConfigInfo() {
    }

    public QAsnXFTPConfigInfo(QAsnXFTPConfigInfo arg) {
        this.ixFtptype = arg.ixFtptype;
        this.iState = arg.iState;
        this.strUserName = new byte[arg.strUserName.length];
        System.arraycopy(arg.strUserName, 0, this.strUserName, 0, arg.strUserName.length);
        this.strPassword = new byte[arg.strPassword.length];
        System.arraycopy(arg.strPassword, 0, this.strPassword, 0, arg.strPassword.length);
        this.strPath = new byte[arg.strPath.length];
        System.arraycopy(arg.strPath, 0, this.strPath, 0, arg.strPath.length);
        this.strIPAdress = new byte[arg.strIPAdress.length];
        System.arraycopy(arg.strIPAdress, 0, this.strIPAdress, 0, arg.strIPAdress.length);
        this.iPort = arg.iPort;
        if (arg.iLocation != null) {
            this.iLocation = arg.iLocation;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.ixFtptype));
        enc.serializeInteger(BigInteger.valueOf(this.iState));
        enc.serializeOctetString(this.strUserName);
        enc.serializeOctetString(this.strPassword);
        enc.serializeOctetString(this.strPath);
        enc.serializeOctetString(this.strIPAdress);
        enc.serializeInteger(BigInteger.valueOf(this.iPort));
        if (this.iLocation != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.iLocation.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.ixFtptype = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.iState = bi.intValue();
        }
        this.strUserName = dec.deserializeOctetString();
        this.strPassword = dec.deserializeOctetString();
        this.strPath = dec.deserializeOctetString();
        this.strIPAdress = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.iPort = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.iLocation = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.iLocation = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ixFtptype = ");
        os.print(this.ixFtptype);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iState = ");
        os.print(this.iState);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strUserName = ");
        os.print(FStruFormat.convertToString((byte[])this.strUserName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strPassword = ");
        os.print(FStruFormat.convertToString((byte[])this.strPassword));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strPath = ");
        os.print(FStruFormat.convertToString((byte[])this.strPath));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strIPAdress = ");
        os.print(FStruFormat.convertToString((byte[])this.strIPAdress));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iPort = ");
        os.print(this.iPort);
        os.println(',');
        if (this.iLocation != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iLocation = ");
            os.print(this.iLocation.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

