/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.q_pms_base;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnThresholdInfo
implements FStruct {
    public byte[] triggerValue;
    public byte[] clearValue;
    public int enAlarmLevel = -1;
    public boolean isHigh;
    public boolean isMonitor;

    public QAsnThresholdInfo() {
    }

    public QAsnThresholdInfo(QAsnThresholdInfo arg) {
        this.triggerValue = new byte[arg.triggerValue.length];
        System.arraycopy(arg.triggerValue, 0, this.triggerValue, 0, arg.triggerValue.length);
        this.clearValue = new byte[arg.clearValue.length];
        System.arraycopy(arg.clearValue, 0, this.clearValue, 0, arg.clearValue.length);
        this.enAlarmLevel = arg.enAlarmLevel;
        this.isHigh = arg.isHigh;
        this.isMonitor = arg.isMonitor;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.triggerValue);
        enc.serializeOctetString(this.clearValue);
        enc.serializeInteger(BigInteger.valueOf(this.enAlarmLevel));
        enc.serializeBoolean(this.isHigh);
        enc.serializeBoolean(this.isMonitor);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.triggerValue = dec.deserializeOctetString();
        this.clearValue = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.enAlarmLevel = bi.intValue();
        }
        this.isHigh = dec.deserializeBoolean();
        this.isMonitor = dec.deserializeBoolean();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("triggerValue = ");
        os.print(FStruFormat.convertToString((byte[])this.triggerValue));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("clearValue = ");
        os.print(FStruFormat.convertToString((byte[])this.clearValue));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("enAlarmLevel = ");
        os.print(this.enAlarmLevel);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isHigh = ");
        os.print(this.isHigh);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isMonitor = ");
        os.print(this.isMonitor);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

