/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.q_pms_base;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnResourceInfo
implements FStruct {
    public byte[] resID;
    public byte[] resName = null;
    public Integer resTypeID = null;
    public int nMainTypeId = -1;
    public int nSubTypeId = -1;
    public byte[] tdtName;
    public int neID = -1;

    public QAsnResourceInfo() {
    }

    public QAsnResourceInfo(QAsnResourceInfo arg) {
        this.resID = new byte[arg.resID.length];
        System.arraycopy(arg.resID, 0, this.resID, 0, arg.resID.length);
        if (arg.resName != null) {
            this.resName = new byte[arg.resName.length];
            System.arraycopy(arg.resName, 0, this.resName, 0, arg.resName.length);
        }
        if (arg.resTypeID != null) {
            this.resTypeID = arg.resTypeID;
        }
        this.nMainTypeId = arg.nMainTypeId;
        this.nSubTypeId = arg.nSubTypeId;
        this.tdtName = new byte[arg.tdtName.length];
        System.arraycopy(arg.tdtName, 0, this.tdtName, 0, arg.tdtName.length);
        this.neID = arg.neID;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.resID);
        if (this.resName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.resName);
        }
        if (this.resTypeID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.resTypeID.intValue()));
        }
        enc.serializeInteger(BigInteger.valueOf(this.nMainTypeId));
        enc.serializeInteger(BigInteger.valueOf(this.nSubTypeId));
        enc.serializeOctetString(this.tdtName);
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        BigInteger bi;
        int seq_nr = dec.deserializeSequence();
        this.resID = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.resName = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.resTypeID = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.resTypeID = bi.intValue();
            }
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.nMainTypeId = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.nSubTypeId = bi.intValue();
        }
        this.tdtName = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.neID = bi.intValue();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("resID = ");
        os.print(FStruFormat.convertToString((byte[])this.resID));
        os.println(',');
        if (this.resName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("resName = ");
            os.print(FStruFormat.convertToString((byte[])this.resName));
            os.println(',');
        }
        if (this.resTypeID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("resTypeID = ");
            os.print(this.resTypeID.toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nMainTypeId = ");
        os.print(this.nMainTypeId);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("nSubTypeId = ");
        os.print(this.nSubTypeId);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("tdtName = ");
        os.print(FStruFormat.convertToString((byte[])this.tdtName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

