/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.q_pms_base;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnIndiValue
implements FStruct {
    public int indiID = -1;
    public byte[] indiValue;

    public QAsnIndiValue() {
    }

    public QAsnIndiValue(QAsnIndiValue arg) {
        this.indiID = arg.indiID;
        this.indiValue = new byte[arg.indiValue.length];
        System.arraycopy(arg.indiValue, 0, this.indiValue, 0, arg.indiValue.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.indiID));
        enc.serializeOctetString(this.indiValue);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.indiID = bi.intValue();
        }
        this.indiValue = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("indiID = ");
        os.print(this.indiID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("indiValue = ");
        os.print(FStruFormat.convertToString((byte[])this.indiValue));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

