/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_wdmnetinterface;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnServerConnectionType
implements FStruct {
    public byte[] sncID;
    public byte[] channel;
    public int usedType = -1;
    public int direction = -1;
    public byte[] fiberID;

    public QAsnServerConnectionType() {
    }

    public QAsnServerConnectionType(QAsnServerConnectionType arg) {
        this.sncID = new byte[arg.sncID.length];
        System.arraycopy(arg.sncID, 0, this.sncID, 0, arg.sncID.length);
        this.channel = new byte[arg.channel.length];
        System.arraycopy(arg.channel, 0, this.channel, 0, arg.channel.length);
        this.usedType = arg.usedType;
        this.direction = arg.direction;
        this.fiberID = new byte[arg.fiberID.length];
        System.arraycopy(arg.fiberID, 0, this.fiberID, 0, arg.fiberID.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.sncID);
        enc.serializeOctetString(this.channel);
        enc.serializeInteger(BigInteger.valueOf(this.usedType));
        enc.serializeInteger(BigInteger.valueOf(this.direction));
        enc.serializeOctetString(this.fiberID);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.sncID = dec.deserializeOctetString();
        this.channel = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.usedType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.direction = bi.intValue();
        }
        this.fiberID = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sncID = ");
        os.print(FStruFormat.convertToString((byte[])this.sncID));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("channel = ");
        os.print(FStruFormat.convertToString((byte[])this.channel));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("usedType = ");
        os.print(this.usedType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("direction = ");
        os.print(this.direction);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("fiberID = ");
        os.print(FStruFormat.convertToString((byte[])this.fiberID));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

