/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_u2000_mds6630;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_u2000_mds6630.QAsnTrailTPName;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnNetTrailConnection
implements FStruct {
    public QAsnPortIndex srcPort = new QAsnPortIndex();
    public QAsnPortIndex snkPort = new QAsnPortIndex();
    public int type = -1;
    public QAsnTrailTPName srcPortName = null;
    public QAsnTrailTPName snkPortName = null;

    public QAsnNetTrailConnection() {
    }

    public QAsnNetTrailConnection(QAsnNetTrailConnection arg) {
        this.srcPort = new QAsnPortIndex(arg.srcPort);
        this.snkPort = new QAsnPortIndex(arg.snkPort);
        this.type = arg.type;
        if (arg.srcPortName != null) {
            this.srcPortName = new QAsnTrailTPName(arg.srcPortName);
        }
        if (arg.snkPortName != null) {
            this.snkPortName = new QAsnTrailTPName(arg.snkPortName);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.srcPort.serialize(enc);
        this.snkPort.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.type));
        if (this.srcPortName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.srcPortName.serialize(enc);
        }
        if (this.snkPortName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.snkPortName.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.srcPort.deserialize(dec);
        this.snkPort.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.type = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.srcPortName = new QAsnTrailTPName();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.srcPortName.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.snkPortName = new QAsnTrailTPName();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.snkPortName.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("srcPort = ");
        this.srcPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snkPort = ");
        this.snkPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("type = ");
        os.print(this.type);
        os.println(',');
        if (this.srcPortName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("srcPortName = ");
            this.srcPortName.print(os, indent + 2);
            os.println(',');
        }
        if (this.snkPortName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("snkPortName = ");
            this.snkPortName.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

