/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_tnp_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnTnpSwitchData
implements FStruct {
    public QAsnUniResID oTNPKey = new QAsnUniResID();
    public int iSwitchPosition = -1;
    public Integer oPerformReason = null;

    public QAsnTnpSwitchData() {
    }

    public QAsnTnpSwitchData(QAsnTnpSwitchData arg) {
        this.oTNPKey = new QAsnUniResID(arg.oTNPKey);
        this.iSwitchPosition = arg.iSwitchPosition;
        if (arg.oPerformReason != null) {
            this.oPerformReason = arg.oPerformReason;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.oTNPKey.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.iSwitchPosition));
        if (this.oPerformReason != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.oPerformReason.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oTNPKey.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.iSwitchPosition = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.oPerformReason = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.oPerformReason = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oTNPKey = ");
        this.oTNPKey.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSwitchPosition = ");
        os.print(this.iSwitchPosition);
        os.println(',');
        if (this.oPerformReason != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oPerformReason = ");
            os.print(this.oPerformReason.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

