/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_tnp_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnTNPHop
implements FStruct {
    public int neID = -1;
    public QAsnUniResID oProtectedGroup = null;
    public int iReversionMode = -1;
    public int iHoldOffTime = -1;
    public int iWtrTime = -1;
    public Integer iHopType = null;

    public QAsnTNPHop() {
    }

    public QAsnTNPHop(QAsnTNPHop arg) {
        this.neID = arg.neID;
        if (arg.oProtectedGroup != null) {
            this.oProtectedGroup = new QAsnUniResID(arg.oProtectedGroup);
        }
        this.iReversionMode = arg.iReversionMode;
        this.iHoldOffTime = arg.iHoldOffTime;
        this.iWtrTime = arg.iWtrTime;
        if (arg.iHopType != null) {
            this.iHopType = arg.iHopType;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        if (this.oProtectedGroup != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.oProtectedGroup.serialize(enc);
        }
        enc.serializeInteger(BigInteger.valueOf(this.iReversionMode));
        enc.serializeInteger(BigInteger.valueOf(this.iHoldOffTime));
        enc.serializeInteger(BigInteger.valueOf(this.iWtrTime));
        if (this.iHopType != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.iHopType.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.neID = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.oProtectedGroup = new QAsnUniResID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.oProtectedGroup.deserialize(dec);
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.iReversionMode = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.iHoldOffTime = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.iWtrTime = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.iHopType = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.iHopType = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        if (this.oProtectedGroup != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("oProtectedGroup = ");
            this.oProtectedGroup.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iReversionMode = ");
        os.print(this.iReversionMode);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iHoldOffTime = ");
        os.print(this.iHoldOffTime);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iWtrTime = ");
        os.print(this.iWtrTime);
        os.println(',');
        if (this.iHopType != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iHopType = ");
            os.print(this.iHopType.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

