/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_tnp_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnTNPBase
implements FStruct {
    public QAsnUniResID oTNPKey = new QAsnUniResID();
    public byte[] userLabel;
    public byte[] aliasName;
    public byte[] owner;
    public int iSrcNeID = -1;
    public int iSinkNeID = -1;
    public int iProtectionGroupType = -1;
    public int iProtectionSchemeState = -1;

    public QAsnTNPBase() {
    }

    public QAsnTNPBase(QAsnTNPBase arg) {
        this.oTNPKey = new QAsnUniResID(arg.oTNPKey);
        this.userLabel = new byte[arg.userLabel.length];
        System.arraycopy(arg.userLabel, 0, this.userLabel, 0, arg.userLabel.length);
        this.aliasName = new byte[arg.aliasName.length];
        System.arraycopy(arg.aliasName, 0, this.aliasName, 0, arg.aliasName.length);
        this.owner = new byte[arg.owner.length];
        System.arraycopy(arg.owner, 0, this.owner, 0, arg.owner.length);
        this.iSrcNeID = arg.iSrcNeID;
        this.iSinkNeID = arg.iSinkNeID;
        this.iProtectionGroupType = arg.iProtectionGroupType;
        this.iProtectionSchemeState = arg.iProtectionSchemeState;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.oTNPKey.serialize(enc);
        enc.serializeOctetString(this.userLabel);
        enc.serializeOctetString(this.aliasName);
        enc.serializeOctetString(this.owner);
        enc.serializeInteger(BigInteger.valueOf(this.iSrcNeID));
        enc.serializeInteger(BigInteger.valueOf(this.iSinkNeID));
        enc.serializeInteger(BigInteger.valueOf(this.iProtectionGroupType));
        enc.serializeInteger(BigInteger.valueOf(this.iProtectionSchemeState));
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.oTNPKey.deserialize(dec);
        this.userLabel = dec.deserializeOctetString();
        this.aliasName = dec.deserializeOctetString();
        this.owner = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.iSrcNeID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.iSinkNeID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.iProtectionGroupType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.iProtectionSchemeState = bi.intValue();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oTNPKey = ");
        this.oTNPKey.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("userLabel = ");
        os.print(FStruFormat.convertToString((byte[])this.userLabel));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("aliasName = ");
        os.print(FStruFormat.convertToString((byte[])this.aliasName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("owner = ");
        os.print(FStruFormat.convertToString((byte[])this.owner));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSrcNeID = ");
        os.print(this.iSrcNeID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iSinkNeID = ");
        os.print(this.iSinkNeID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iProtectionGroupType = ");
        os.print(this.iProtectionGroupType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iProtectionSchemeState = ");
        os.print(this.iProtectionSchemeState);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

