/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_sdh_trail;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnFiberSrcSnkInfo
implements FStruct {
    public int linkId = -1;
    public QAsnPortIndex src = new QAsnPortIndex();
    public QAsnPortIndex snk = new QAsnPortIndex();

    public AsnFiberSrcSnkInfo() {
    }

    public AsnFiberSrcSnkInfo(AsnFiberSrcSnkInfo arg) {
        this.linkId = arg.linkId;
        this.src = new QAsnPortIndex(arg.src);
        this.snk = new QAsnPortIndex(arg.snk);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.linkId));
        this.src.serialize(enc);
        this.snk.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.linkId = bi.intValue();
        }
        this.src.deserialize(dec);
        this.snk.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("linkId = ");
        os.print(this.linkId);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("src = ");
        this.src.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snk = ");
        this.snk.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

