/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_sdh_protect;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_sdh_protect.QAsnCPMapInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnXPICInfo
implements FStruct {
    public int neID = -1;
    public int xpicID = -1;
    public int channelBandwidth = -1;
    public QAsnCPMapInfo vDirection = new QAsnCPMapInfo();
    public int vLinkID = -1;
    public QAsnCPMapInfo hDirection = new QAsnCPMapInfo();
    public int hLinkID = -1;
    public byte[] maxTrasnmitPower;
    public byte[] transmitPower;
    public byte[] transmissionFreq;
    public byte[] trSpace;
    public int transmitSatus = -1;
    public int atpcEnable = -1;
    public byte[] aTPCUpperThreshold;
    public byte[] aTPCLowerThreshold;
    public int aTPCAutoThresholdStatus = -1;
    public byte[] xpicName = null;
    public byte[] xpicOwner = null;
    public byte[] xpicUserLabel = null;
    public QAsnNVSList exAttrbList = null;

    public QAsnXPICInfo() {
    }

    public QAsnXPICInfo(QAsnXPICInfo arg) {
        this.neID = arg.neID;
        this.xpicID = arg.xpicID;
        this.channelBandwidth = arg.channelBandwidth;
        this.vDirection = new QAsnCPMapInfo(arg.vDirection);
        this.vLinkID = arg.vLinkID;
        this.hDirection = new QAsnCPMapInfo(arg.hDirection);
        this.hLinkID = arg.hLinkID;
        this.maxTrasnmitPower = new byte[arg.maxTrasnmitPower.length];
        System.arraycopy(arg.maxTrasnmitPower, 0, this.maxTrasnmitPower, 0, arg.maxTrasnmitPower.length);
        this.transmitPower = new byte[arg.transmitPower.length];
        System.arraycopy(arg.transmitPower, 0, this.transmitPower, 0, arg.transmitPower.length);
        this.transmissionFreq = new byte[arg.transmissionFreq.length];
        System.arraycopy(arg.transmissionFreq, 0, this.transmissionFreq, 0, arg.transmissionFreq.length);
        this.trSpace = new byte[arg.trSpace.length];
        System.arraycopy(arg.trSpace, 0, this.trSpace, 0, arg.trSpace.length);
        this.transmitSatus = arg.transmitSatus;
        this.atpcEnable = arg.atpcEnable;
        this.aTPCUpperThreshold = new byte[arg.aTPCUpperThreshold.length];
        System.arraycopy(arg.aTPCUpperThreshold, 0, this.aTPCUpperThreshold, 0, arg.aTPCUpperThreshold.length);
        this.aTPCLowerThreshold = new byte[arg.aTPCLowerThreshold.length];
        System.arraycopy(arg.aTPCLowerThreshold, 0, this.aTPCLowerThreshold, 0, arg.aTPCLowerThreshold.length);
        this.aTPCAutoThresholdStatus = arg.aTPCAutoThresholdStatus;
        if (arg.xpicName != null) {
            this.xpicName = new byte[arg.xpicName.length];
            System.arraycopy(arg.xpicName, 0, this.xpicName, 0, arg.xpicName.length);
        }
        if (arg.xpicOwner != null) {
            this.xpicOwner = new byte[arg.xpicOwner.length];
            System.arraycopy(arg.xpicOwner, 0, this.xpicOwner, 0, arg.xpicOwner.length);
        }
        if (arg.xpicUserLabel != null) {
            this.xpicUserLabel = new byte[arg.xpicUserLabel.length];
            System.arraycopy(arg.xpicUserLabel, 0, this.xpicUserLabel, 0, arg.xpicUserLabel.length);
        }
        if (arg.exAttrbList != null) {
            this.exAttrbList = new QAsnNVSList(arg.exAttrbList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        enc.serializeInteger(BigInteger.valueOf(this.xpicID));
        enc.serializeInteger(BigInteger.valueOf(this.channelBandwidth));
        this.vDirection.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.vLinkID));
        this.hDirection.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.hLinkID));
        enc.serializeOctetString(this.maxTrasnmitPower);
        enc.serializeOctetString(this.transmitPower);
        enc.serializeOctetString(this.transmissionFreq);
        enc.serializeOctetString(this.trSpace);
        enc.serializeInteger(BigInteger.valueOf(this.transmitSatus));
        enc.serializeInteger(BigInteger.valueOf(this.atpcEnable));
        enc.serializeOctetString(this.aTPCUpperThreshold);
        enc.serializeOctetString(this.aTPCLowerThreshold);
        enc.serializeInteger(BigInteger.valueOf(this.aTPCAutoThresholdStatus));
        if (this.xpicName != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.xpicName);
        }
        if (this.xpicOwner != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.xpicOwner);
        }
        if (this.xpicUserLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeOctetString(this.xpicUserLabel);
        }
        if (this.exAttrbList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            this.exAttrbList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.neID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.xpicID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.channelBandwidth = bi.intValue();
        }
        this.vDirection.deserialize(dec);
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.vLinkID = bi.intValue();
        }
        this.hDirection.deserialize(dec);
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.hLinkID = bi.intValue();
        }
        this.maxTrasnmitPower = dec.deserializeOctetString();
        this.transmitPower = dec.deserializeOctetString();
        this.transmissionFreq = dec.deserializeOctetString();
        this.trSpace = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.transmitSatus = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.atpcEnable = bi.intValue();
        }
        this.aTPCUpperThreshold = dec.deserializeOctetString();
        this.aTPCLowerThreshold = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.aTPCAutoThresholdStatus = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.xpicName = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.xpicOwner = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.xpicUserLabel = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.exAttrbList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.exAttrbList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("xpicID = ");
        os.print(this.xpicID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("channelBandwidth = ");
        os.print(this.channelBandwidth);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("vDirection = ");
        this.vDirection.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("vLinkID = ");
        os.print(this.vLinkID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("hDirection = ");
        this.hDirection.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("hLinkID = ");
        os.print(this.hLinkID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("maxTrasnmitPower = ");
        os.print(FStruFormat.convertToString((byte[])this.maxTrasnmitPower));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("transmitPower = ");
        os.print(FStruFormat.convertToString((byte[])this.transmitPower));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("transmissionFreq = ");
        os.print(FStruFormat.convertToString((byte[])this.transmissionFreq));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trSpace = ");
        os.print(FStruFormat.convertToString((byte[])this.trSpace));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("transmitSatus = ");
        os.print(this.transmitSatus);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("atpcEnable = ");
        os.print(this.atpcEnable);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("aTPCUpperThreshold = ");
        os.print(FStruFormat.convertToString((byte[])this.aTPCUpperThreshold));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("aTPCLowerThreshold = ");
        os.print(FStruFormat.convertToString((byte[])this.aTPCLowerThreshold));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("aTPCAutoThresholdStatus = ");
        os.print(this.aTPCAutoThresholdStatus);
        os.println(',');
        if (this.xpicName != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("xpicName = ");
            os.print(FStruFormat.convertToString((byte[])this.xpicName));
            os.println(',');
        }
        if (this.xpicOwner != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("xpicOwner = ");
            os.print(FStruFormat.convertToString((byte[])this.xpicOwner));
            os.println(',');
        }
        if (this.xpicUserLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("xpicUserLabel = ");
            os.print(FStruFormat.convertToString((byte[])this.xpicUserLabel));
            os.println(',');
        }
        if (this.exAttrbList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("exAttrbList = ");
            this.exAttrbList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

