/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_sdh_protect;

import com.huawei.network.qasn.m_q_sdh_protect.QAsnCPMapInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnIFSWState
implements FStruct {
    public int unitType = -1;
    public int swState = -1;
    public int protectedUnit = -1;
    public int indication = -1;
    public QAsnCPMapInfo unitCPInfo = null;

    public AsnIFSWState() {
    }

    public AsnIFSWState(AsnIFSWState arg) {
        this.unitType = arg.unitType;
        this.swState = arg.swState;
        this.protectedUnit = arg.protectedUnit;
        this.indication = arg.indication;
        if (arg.unitCPInfo != null) {
            this.unitCPInfo = new QAsnCPMapInfo(arg.unitCPInfo);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.unitType));
        enc.serializeInteger(BigInteger.valueOf(this.swState));
        enc.serializeInteger(BigInteger.valueOf(this.protectedUnit));
        enc.serializeInteger(BigInteger.valueOf(this.indication));
        if (this.unitCPInfo != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.unitCPInfo.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.unitType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.swState = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.protectedUnit = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.indication = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.unitCPInfo = new QAsnCPMapInfo();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.unitCPInfo.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("unitType = ");
        os.print(this.unitType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("swState = ");
        os.print(this.swState);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("protectedUnit = ");
        os.print(this.protectedUnit);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("indication = ");
        os.print(this.indication);
        os.println(',');
        if (this.unitCPInfo != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("unitCPInfo = ");
            this.unitCPInfo.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

