/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_rmon;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnAtmEventRecord
implements FStruct {
    public int eventID = -1;
    public byte[] value;
    public int period = -1;
    public int monTime = -1;

    public QAsnAtmEventRecord() {
    }

    public QAsnAtmEventRecord(QAsnAtmEventRecord arg) {
        this.eventID = arg.eventID;
        this.value = new byte[arg.value.length];
        System.arraycopy(arg.value, 0, this.value, 0, arg.value.length);
        this.period = arg.period;
        this.monTime = arg.monTime;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.eventID));
        enc.serializeOctetString(this.value);
        enc.serializeInteger(BigInteger.valueOf(this.period));
        enc.serializeInteger(BigInteger.valueOf(this.monTime));
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.eventID = bi.intValue();
        }
        this.value = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.period = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.monTime = bi.intValue();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("eventID = ");
        os.print(this.eventID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("value = ");
        os.print(FStruFormat.convertToString((byte[])this.value));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("period = ");
        os.print(this.period);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("monTime = ");
        os.print(this.monTime);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

