/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_pms_rtp;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnErrorResponse
implements FStruct {
    public BigInteger errorCode;
    public byte[] errMsg = null;

    public QAsnErrorResponse() {
    }

    public QAsnErrorResponse(QAsnErrorResponse arg) {
        this.errorCode = arg.errorCode;
        if (arg.errMsg != null) {
            this.errMsg = new byte[arg.errMsg.length];
            System.arraycopy(arg.errMsg, 0, this.errMsg, 0, arg.errMsg.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.errorCode);
        if (this.errMsg != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.errMsg);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.errorCode = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.errMsg = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("errorCode = ");
        os.print(this.errorCode.toString());
        os.println(',');
        if (this.errMsg != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("errMsg = ");
            os.print(FStruFormat.convertToString((byte[])this.errMsg));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

