/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_performance;

import com.huawei.network.qasn.m_q_common.QAsnDateTimeType;
import com.huawei.network.qasn.m_q_performance.QAsnExPfmMonObj;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnExPfmDataRecord
implements FStruct {
    public QAsnExPfmMonObj moObj = new QAsnExPfmMonObj();
    public QAsnDateTimeType startTime = null;
    public QAsnDateTimeType endTime = null;
    public int period = -1;
    public int evtID = -1;
    public byte[] value;

    public QAsnExPfmDataRecord() {
    }

    public QAsnExPfmDataRecord(QAsnExPfmDataRecord arg) {
        this.moObj = new QAsnExPfmMonObj(arg.moObj);
        if (arg.startTime != null) {
            this.startTime = new QAsnDateTimeType(arg.startTime);
        }
        if (arg.endTime != null) {
            this.endTime = new QAsnDateTimeType(arg.endTime);
        }
        this.period = arg.period;
        this.evtID = arg.evtID;
        this.value = new byte[arg.value.length];
        System.arraycopy(arg.value, 0, this.value, 0, arg.value.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.moObj.serialize(enc);
        if (this.startTime != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.startTime.serialize(enc);
        }
        if (this.endTime != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.endTime.serialize(enc);
        }
        enc.serializeInteger(BigInteger.valueOf(this.period));
        enc.serializeInteger(BigInteger.valueOf(this.evtID));
        enc.serializeOctetString(this.value);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        BigInteger bi;
        int seq_nr = dec.deserializeSequence();
        this.moObj.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.startTime = new QAsnDateTimeType();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.startTime.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.endTime = new QAsnDateTimeType();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.endTime.deserialize(dec);
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.period = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.evtID = bi.intValue();
        }
        this.value = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("moObj = ");
        this.moObj.print(os, indent + 2);
        os.println(',');
        if (this.startTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("startTime = ");
            this.startTime.print(os, indent + 2);
            os.println(',');
        }
        if (this.endTime != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("endTime = ");
            this.endTime.print(os, indent + 2);
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("period = ");
        os.print(this.period);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("evtID = ");
        os.print(this.evtID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("value = ");
        os.print(FStruFormat.convertToString((byte[])this.value));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

