/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_otnxc;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_otnxc.QAsnSrcSnkPortPairList;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnOXCRouteData
implements FStruct {
    public QAsnPortIndex srcPort = new QAsnPortIndex();
    public QAsnPortIndex snkPort = new QAsnPortIndex();
    public QAsnSrcSnkPortPairList xcSrcSnkPortList = new QAsnSrcSnkPortPairList();
    public Integer opticMode = null;

    public QAsnOXCRouteData() {
    }

    public QAsnOXCRouteData(QAsnOXCRouteData arg) {
        this.srcPort = new QAsnPortIndex(arg.srcPort);
        this.snkPort = new QAsnPortIndex(arg.snkPort);
        this.xcSrcSnkPortList = new QAsnSrcSnkPortPairList(arg.xcSrcSnkPortList);
        if (arg.opticMode != null) {
            this.opticMode = arg.opticMode;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.srcPort.serialize(enc);
        this.snkPort.serialize(enc);
        this.xcSrcSnkPortList.serialize(enc);
        if (this.opticMode != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.opticMode.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.srcPort.deserialize(dec);
        this.snkPort.deserialize(dec);
        this.xcSrcSnkPortList.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.opticMode = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            BigInteger bi = dec.deserializeInteger();
            if (null != bi) {
                this.opticMode = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("srcPort = ");
        this.srcPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snkPort = ");
        this.snkPort.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("xcSrcSnkPortList = ");
        this.xcSrcSnkPortList.print(os, indent + 2);
        os.println(',');
        if (this.opticMode != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("opticMode = ");
            os.print(this.opticMode.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

