/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_otnxc;

import com.huawei.network.qasn.m_q_otnxc.QAsnOTNXC;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnOTNXCPair
implements FStruct {
    public QAsnOTNXC workXC = new QAsnOTNXC();
    public QAsnOTNXC relatedXC = null;
    public Integer xcGroupID = null;
    public Integer sncpPGID = null;

    public QAsnOTNXCPair() {
    }

    public QAsnOTNXCPair(QAsnOTNXCPair arg) {
        this.workXC = new QAsnOTNXC(arg.workXC);
        if (arg.relatedXC != null) {
            this.relatedXC = new QAsnOTNXC(arg.relatedXC);
        }
        if (arg.xcGroupID != null) {
            this.xcGroupID = arg.xcGroupID;
        }
        if (arg.sncpPGID != null) {
            this.sncpPGID = arg.sncpPGID;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.workXC.serialize(enc);
        if (this.relatedXC != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.relatedXC.serialize(enc);
        }
        if (this.xcGroupID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.xcGroupID.intValue()));
        }
        if (this.sncpPGID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(BigInteger.valueOf(this.sncpPGID.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        BigInteger bi;
        int seq_nr = dec.deserializeSequence();
        this.workXC.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.relatedXC = new QAsnOTNXC();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.relatedXC.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.xcGroupID = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.xcGroupID = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.sncpPGID = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.sncpPGID = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("workXC = ");
        this.workXC.print(os, indent + 2);
        os.println(',');
        if (this.relatedXC != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("relatedXC = ");
            this.relatedXC.print(os, indent + 2);
            os.println(',');
        }
        if (this.xcGroupID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("xcGroupID = ");
            os.print(this.xcGroupID.toString());
            os.println(',');
        }
        if (this.sncpPGID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("sncpPGID = ");
            os.print(this.sncpPGID.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

