/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_otntrailsyn;

import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnOTNTrailBaseInfo
implements FStruct {
    public BigInteger trailID;
    public BigInteger level;
    public BigInteger direct;
    public QAsnPortIndex srcPortInfo = new QAsnPortIndex();
    public QAsnPortIndex snkPortInfo = new QAsnPortIndex();

    public QAsnOTNTrailBaseInfo() {
    }

    public QAsnOTNTrailBaseInfo(QAsnOTNTrailBaseInfo arg) {
        this.trailID = arg.trailID;
        this.level = arg.level;
        this.direct = arg.direct;
        this.srcPortInfo = new QAsnPortIndex(arg.srcPortInfo);
        this.snkPortInfo = new QAsnPortIndex(arg.snkPortInfo);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.trailID);
        enc.serializeInteger(this.level);
        enc.serializeInteger(this.direct);
        this.srcPortInfo.serialize(enc);
        this.snkPortInfo.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.trailID = dec.deserializeInteger();
        this.level = dec.deserializeInteger();
        this.direct = dec.deserializeInteger();
        this.srcPortInfo.deserialize(dec);
        this.snkPortInfo.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("trailID = ");
        os.print(this.trailID.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("level = ");
        os.print(this.level.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("direct = ");
        os.print(this.direct.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("srcPortInfo = ");
        this.srcPortInfo.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("snkPortInfo = ");
        this.snkPortInfo.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

