/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_nmlpfm;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnCommonResult
implements FStruct {
    public BigInteger objectId;
    public byte[] objectName;
    public BigInteger retCode;

    public QAsnCommonResult() {
    }

    public QAsnCommonResult(QAsnCommonResult arg) {
        this.objectId = arg.objectId;
        this.objectName = new byte[arg.objectName.length];
        System.arraycopy(arg.objectName, 0, this.objectName, 0, arg.objectName.length);
        this.retCode = arg.retCode;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.objectId);
        enc.serializeOctetString(this.objectName);
        enc.serializeInteger(this.retCode);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.objectId = dec.deserializeInteger();
        this.objectName = dec.deserializeOctetString();
        this.retCode = dec.deserializeInteger();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("objectId = ");
        os.print(this.objectId.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("objectName = ");
        os.print(FStruFormat.convertToString((byte[])this.objectName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("retCode = ");
        os.print(this.retCode.toString());
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

