/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_nmleth;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class AsnLocationInfo
implements FStruct {
    public int oneID = -1;
    public int neID = -1;
    public BigInteger cpSlot;
    public BigInteger subSlot;
    public BigInteger portID;
    public BigInteger pathId1 = null;
    public BigInteger pathId2 = null;

    public AsnLocationInfo() {
    }

    public AsnLocationInfo(AsnLocationInfo arg) {
        this.oneID = arg.oneID;
        this.neID = arg.neID;
        this.cpSlot = arg.cpSlot;
        this.subSlot = arg.subSlot;
        this.portID = arg.portID;
        if (arg.pathId1 != null) {
            this.pathId1 = arg.pathId1;
        }
        if (arg.pathId2 != null) {
            this.pathId2 = arg.pathId2;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.oneID));
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        enc.serializeInteger(this.cpSlot);
        enc.serializeInteger(this.subSlot);
        enc.serializeInteger(this.portID);
        if (this.pathId1 != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.pathId1);
        }
        if (this.pathId2 != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.pathId2);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.oneID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.neID = bi.intValue();
        }
        this.cpSlot = dec.deserializeInteger();
        this.subSlot = dec.deserializeInteger();
        this.portID = dec.deserializeInteger();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.pathId1 = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.pathId2 = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("oneID = ");
        os.print(this.oneID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("cpSlot = ");
        os.print(this.cpSlot.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("subSlot = ");
        os.print(this.subSlot.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portID = ");
        os.print(this.portID.toString());
        os.println(',');
        if (this.pathId1 != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("pathId1 = ");
            os.print(this.pathId1.toString());
            os.println(',');
        }
        if (this.pathId2 != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("pathId2 = ");
            os.print(this.pathId2.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

