/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_nml_erps;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnPortIndex;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnTrunkIndex
implements FStruct {
    public QAsnUniResID key = new QAsnUniResID();
    public QAsnPortIndex portIndex = new QAsnPortIndex();
    public int portType = -1;
    public QAsnNVSList poExAttrList = null;

    public QAsnTrunkIndex() {
    }

    public QAsnTrunkIndex(QAsnTrunkIndex arg) {
        this.key = new QAsnUniResID(arg.key);
        this.portIndex = new QAsnPortIndex(arg.portIndex);
        this.portType = arg.portType;
        if (arg.poExAttrList != null) {
            this.poExAttrList = new QAsnNVSList(arg.poExAttrList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.key.serialize(enc);
        this.portIndex.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.portType));
        if (this.poExAttrList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.poExAttrList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.key.deserialize(dec);
        this.portIndex.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.portType = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poExAttrList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poExAttrList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("key = ");
        this.key.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portIndex = ");
        this.portIndex.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portType = ");
        os.print(this.portType);
        os.println(',');
        if (this.poExAttrList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poExAttrList = ");
            this.poExAttrList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

