/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_nml_clock_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnClockPort
implements FStruct {
    public QAsnUniResID portIndex = new QAsnUniResID();
    public int portClockType = -1;
    public int mode = -1;
    public int state = -1;
    public byte[] portName;
    public byte[] poPortCompensator = null;

    public QAsnClockPort() {
    }

    public QAsnClockPort(QAsnClockPort arg) {
        this.portIndex = new QAsnUniResID(arg.portIndex);
        this.portClockType = arg.portClockType;
        this.mode = arg.mode;
        this.state = arg.state;
        this.portName = new byte[arg.portName.length];
        System.arraycopy(arg.portName, 0, this.portName, 0, arg.portName.length);
        if (arg.poPortCompensator != null) {
            this.poPortCompensator = new byte[arg.poPortCompensator.length];
            System.arraycopy(arg.poPortCompensator, 0, this.poPortCompensator, 0, arg.poPortCompensator.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.portIndex.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.portClockType));
        enc.serializeInteger(BigInteger.valueOf(this.mode));
        enc.serializeInteger(BigInteger.valueOf(this.state));
        enc.serializeOctetString(this.portName);
        if (this.poPortCompensator != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.poPortCompensator);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.portIndex.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.portClockType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.mode = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.state = bi.intValue();
        }
        this.portName = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poPortCompensator = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portIndex = ");
        this.portIndex.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portClockType = ");
        os.print(this.portClockType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("mode = ");
        os.print(this.mode);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("state = ");
        os.print(this.state);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portName = ");
        os.print(FStruFormat.convertToString((byte[])this.portName));
        os.println(',');
        if (this.poPortCompensator != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poPortCompensator = ");
            os.print(FStruFormat.convertToString((byte[])this.poPortCompensator));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

