/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ipoam;

import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnNodeInfo
implements FStruct {
    public int pairID = -1;
    public int portID = -1;
    public int portType = -1;
    public int serviceID = -1;
    public int serviceType = -1;
    public int dir = -1;
    public Integer vlanID = null;
    public Integer vbID = null;
    public QAsnSingleReturn result = new QAsnSingleReturn();

    public QAsnNodeInfo() {
    }

    public QAsnNodeInfo(QAsnNodeInfo arg) {
        this.pairID = arg.pairID;
        this.portID = arg.portID;
        this.portType = arg.portType;
        this.serviceID = arg.serviceID;
        this.serviceType = arg.serviceType;
        this.dir = arg.dir;
        if (arg.vlanID != null) {
            this.vlanID = arg.vlanID;
        }
        if (arg.vbID != null) {
            this.vbID = arg.vbID;
        }
        this.result = new QAsnSingleReturn(arg.result);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.pairID));
        enc.serializeInteger(BigInteger.valueOf(this.portID));
        enc.serializeInteger(BigInteger.valueOf(this.portType));
        enc.serializeInteger(BigInteger.valueOf(this.serviceID));
        enc.serializeInteger(BigInteger.valueOf(this.serviceType));
        enc.serializeInteger(BigInteger.valueOf(this.dir));
        if (this.vlanID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.vlanID.intValue()));
        }
        if (this.vbID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(BigInteger.valueOf(this.vbID.intValue()));
        }
        this.result.serialize(enc);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.pairID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.portID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.portType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.serviceID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.serviceType = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.dir = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.vlanID = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.vlanID = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.vbID = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.vbID = bi.intValue();
            }
        }
        this.result.deserialize(dec);
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("pairID = ");
        os.print(this.pairID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portID = ");
        os.print(this.portID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portType = ");
        os.print(this.portType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("serviceID = ");
        os.print(this.serviceID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("serviceType = ");
        os.print(this.serviceType);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("dir = ");
        os.print(this.dir);
        os.println(',');
        if (this.vlanID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("vlanID = ");
            os.print(this.vlanID.toString());
            os.println(',');
        }
        if (this.vbID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("vbID = ");
            os.print(this.vbID.toString());
            os.println(',');
        }
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("result = ");
        this.result.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

