/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_tunnel_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnTunnelTPIndex
implements FStruct {
    public int neID = -1;
    public byte[] neIP;
    public byte[] ipAddress;
    public BigInteger label;
    public QAsnUniResID portFdn = new QAsnUniResID();
    public BigInteger poOperMask = null;
    public BigInteger poRevLabel = null;

    public QAsnTunnelTPIndex() {
    }

    public QAsnTunnelTPIndex(QAsnTunnelTPIndex arg) {
        this.neID = arg.neID;
        this.neIP = new byte[arg.neIP.length];
        System.arraycopy(arg.neIP, 0, this.neIP, 0, arg.neIP.length);
        this.ipAddress = new byte[arg.ipAddress.length];
        System.arraycopy(arg.ipAddress, 0, this.ipAddress, 0, arg.ipAddress.length);
        this.label = arg.label;
        this.portFdn = new QAsnUniResID(arg.portFdn);
        if (arg.poOperMask != null) {
            this.poOperMask = arg.poOperMask;
        }
        if (arg.poRevLabel != null) {
            this.poRevLabel = arg.poRevLabel;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.neID));
        enc.serializeOctetString(this.neIP);
        enc.serializeOctetString(this.ipAddress);
        enc.serializeInteger(this.label);
        this.portFdn.serialize(enc);
        if (this.poOperMask != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(this.poOperMask);
        }
        if (this.poRevLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.poRevLabel);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.neID = bi.intValue();
        }
        this.neIP = dec.deserializeOctetString();
        this.ipAddress = dec.deserializeOctetString();
        this.label = dec.deserializeInteger();
        this.portFdn.deserialize(dec);
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poOperMask = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.poRevLabel = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neID = ");
        os.print(this.neID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("neIP = ");
        os.print(FStruFormat.convertToString((byte[])this.neIP));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ipAddress = ");
        os.print(FStruFormat.convertToString((byte[])this.ipAddress));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("label = ");
        os.print(this.label.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("portFdn = ");
        this.portFdn.print(os, indent + 2);
        os.println(',');
        if (this.poOperMask != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poOperMask = ");
            os.print(this.poOperMask.toString());
            os.println(',');
        }
        if (this.poRevLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poRevLabel = ");
            os.print(this.poRevLabel.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

