/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_tunnel_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnTnlTrailSection
implements FStruct {
    public int serverType = -1;
    public QAsnUniResID serverLinkResID = null;
    public byte[] sncID = null;
    public Integer iLabel = null;
    public Integer iRevLabel = null;

    public QAsnTnlTrailSection() {
    }

    public QAsnTnlTrailSection(QAsnTnlTrailSection arg) {
        this.serverType = arg.serverType;
        if (arg.serverLinkResID != null) {
            this.serverLinkResID = new QAsnUniResID(arg.serverLinkResID);
        }
        if (arg.sncID != null) {
            this.sncID = new byte[arg.sncID.length];
            System.arraycopy(arg.sncID, 0, this.sncID, 0, arg.sncID.length);
        }
        if (arg.iLabel != null) {
            this.iLabel = arg.iLabel;
        }
        if (arg.iRevLabel != null) {
            this.iRevLabel = arg.iRevLabel;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.serverType));
        if (this.serverLinkResID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.serverLinkResID.serialize(enc);
        }
        if (this.sncID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.sncID);
        }
        if (this.iLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(BigInteger.valueOf(this.iLabel.intValue()));
        }
        if (this.iRevLabel != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            enc.serializeInteger(BigInteger.valueOf(this.iRevLabel.intValue()));
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.serverType = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.serverLinkResID = new QAsnUniResID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.serverLinkResID.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.sncID = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.iLabel = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.iLabel = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.iRevLabel = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.iRevLabel = bi.intValue();
            }
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("serverType = ");
        os.print(this.serverType);
        os.println(',');
        if (this.serverLinkResID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("serverLinkResID = ");
            this.serverLinkResID.print(os, indent + 2);
            os.println(',');
        }
        if (this.sncID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("sncID = ");
            os.print(FStruFormat.convertToString((byte[])this.sncID));
            os.println(',');
        }
        if (this.iLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iLabel = ");
            os.print(this.iLabel.toString());
            os.println(',');
        }
        if (this.iRevLabel != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("iRevLabel = ");
            os.print(this.iRevLabel.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

