/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_testdiag_model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnTestSuiteInfo
implements FStruct {
    public int suiteID = -1;
    public byte[] suiteName;
    public int svcID = -1;
    public byte[] svcName;
    public int svcType = -1;
    public byte[] poDescription = null;

    public QAsnTestSuiteInfo() {
    }

    public QAsnTestSuiteInfo(QAsnTestSuiteInfo arg) {
        this.suiteID = arg.suiteID;
        this.suiteName = new byte[arg.suiteName.length];
        System.arraycopy(arg.suiteName, 0, this.suiteName, 0, arg.suiteName.length);
        this.svcID = arg.svcID;
        this.svcName = new byte[arg.svcName.length];
        System.arraycopy(arg.svcName, 0, this.svcName, 0, arg.svcName.length);
        this.svcType = arg.svcType;
        if (arg.poDescription != null) {
            this.poDescription = new byte[arg.poDescription.length];
            System.arraycopy(arg.poDescription, 0, this.poDescription, 0, arg.poDescription.length);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.suiteID));
        enc.serializeOctetString(this.suiteName);
        enc.serializeInteger(BigInteger.valueOf(this.svcID));
        enc.serializeOctetString(this.svcName);
        enc.serializeInteger(BigInteger.valueOf(this.svcType));
        if (this.poDescription != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.poDescription);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.suiteID = bi.intValue();
        }
        this.suiteName = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.svcID = bi.intValue();
        }
        this.svcName = dec.deserializeOctetString();
        bi = dec.deserializeInteger();
        if (null != bi) {
            this.svcType = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poDescription = dec.deserializeOctetString();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("suiteID = ");
        os.print(this.suiteID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("suiteName = ");
        os.print(FStruFormat.convertToString((byte[])this.suiteName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("svcID = ");
        os.print(this.svcID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("svcName = ");
        os.print(FStruFormat.convertToString((byte[])this.svcName));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("svcType = ");
        os.print(this.svcType);
        os.println(',');
        if (this.poDescription != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poDescription = ");
            os.print(FStruFormat.convertToString((byte[])this.poDescription));
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

