/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_template_model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnEmlCommonTemplate
implements FStruct {
    public int iTemplID = -1;
    public int iDataFileID = -1;
    public byte[] strConfiglet;

    public AsnEmlCommonTemplate() {
    }

    public AsnEmlCommonTemplate(AsnEmlCommonTemplate arg) {
        this.iTemplID = arg.iTemplID;
        this.iDataFileID = arg.iDataFileID;
        this.strConfiglet = new byte[arg.strConfiglet.length];
        System.arraycopy(arg.strConfiglet, 0, this.strConfiglet, 0, arg.strConfiglet.length);
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.iTemplID));
        enc.serializeInteger(BigInteger.valueOf(this.iDataFileID));
        enc.serializeOctetString(this.strConfiglet);
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.iTemplID = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.iDataFileID = bi.intValue();
        }
        this.strConfiglet = dec.deserializeOctetString();
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iTemplID = ");
        os.print(this.iTemplID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iDataFileID = ");
        os.print(this.iDataFileID);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strConfiglet = ");
        os.print(FStruFormat.convertToString((byte[])this.strConfiglet));
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

