/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_spring_model;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnSPRingType
implements FStruct {
    public QAsnUniResID ringKey = new QAsnUniResID();
    public int ringType = -1;
    public QAsnErrInfo poResult = null;

    public QAsnSPRingType() {
    }

    public QAsnSPRingType(QAsnSPRingType arg) {
        this.ringKey = new QAsnUniResID(arg.ringKey);
        this.ringType = arg.ringType;
        if (arg.poResult != null) {
            this.poResult = new QAsnErrInfo(arg.poResult);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.ringKey.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.ringType));
        if (this.poResult != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.poResult.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.ringKey.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.ringType = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poResult = new QAsnErrInfo();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poResult.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ringKey = ");
        this.ringKey.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ringType = ");
        os.print(this.ringType);
        os.println(',');
        if (this.poResult != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poResult = ");
            this.poResult.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

