/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_section_model;

import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnSectionInfo
implements FStruct {
    public QAsnUniResID sectionKey = new QAsnUniResID();
    public QAsnUniResID ifKey = new QAsnUniResID();
    public byte[] strNextHop;
    public Integer poSectionID = null;
    public byte[] poSinkNode = null;
    public QAsnSingleReturn poResult = null;

    public QAsnSectionInfo() {
    }

    public QAsnSectionInfo(QAsnSectionInfo arg) {
        this.sectionKey = new QAsnUniResID(arg.sectionKey);
        this.ifKey = new QAsnUniResID(arg.ifKey);
        this.strNextHop = new byte[arg.strNextHop.length];
        System.arraycopy(arg.strNextHop, 0, this.strNextHop, 0, arg.strNextHop.length);
        if (arg.poSectionID != null) {
            this.poSectionID = arg.poSectionID;
        }
        if (arg.poSinkNode != null) {
            this.poSinkNode = new byte[arg.poSinkNode.length];
            System.arraycopy(arg.poSinkNode, 0, this.poSinkNode, 0, arg.poSinkNode.length);
        }
        if (arg.poResult != null) {
            this.poResult = new QAsnSingleReturn(arg.poResult);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.sectionKey.serialize(enc);
        this.ifKey.serialize(enc);
        enc.serializeOctetString(this.strNextHop);
        if (this.poSectionID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.poSectionID.intValue()));
        }
        if (this.poSinkNode != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeOctetString(this.poSinkNode);
        }
        if (this.poResult != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            this.poResult.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.sectionKey.deserialize(dec);
        this.ifKey.deserialize(dec);
        this.strNextHop = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poSectionID = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            BigInteger bi = dec.deserializeInteger();
            if (null != bi) {
                this.poSectionID = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.poSinkNode = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.poResult = new QAsnSingleReturn();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.poResult.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("sectionKey = ");
        this.sectionKey.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ifKey = ");
        this.ifKey.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("strNextHop = ");
        os.print(FStruFormat.convertToString((byte[])this.strNextHop));
        os.println(',');
        if (this.poSectionID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poSectionID = ");
            os.print(this.poSectionID.toString());
            os.println(',');
        }
        if (this.poSinkNode != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poSinkNode = ");
            os.print(FStruFormat.convertToString((byte[])this.poSinkNode));
            os.println(',');
        }
        if (this.poResult != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poResult = ");
            this.poResult.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

