/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_pwe3_model;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnSerialNo2BWPair
implements FStruct {
    public int serialNo = -1;
    public int bandWidth = -1;
    public QAsnErrInfo poResult = null;

    public QAsnSerialNo2BWPair() {
    }

    public QAsnSerialNo2BWPair(QAsnSerialNo2BWPair arg) {
        this.serialNo = arg.serialNo;
        this.bandWidth = arg.bandWidth;
        if (arg.poResult != null) {
            this.poResult = new QAsnErrInfo(arg.poResult);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(BigInteger.valueOf(this.serialNo));
        enc.serializeInteger(BigInteger.valueOf(this.bandWidth));
        if (this.poResult != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            this.poResult.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.serialNo = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.bandWidth = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poResult = new QAsnErrInfo();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poResult.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("serialNo = ");
        os.print(this.serialNo);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("bandWidth = ");
        os.print(this.bandWidth);
        os.println(',');
        if (this.poResult != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poResult = ");
            this.poResult.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

