/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_link_model;

import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;

public class QAsnIPInterface
implements FStruct {
    public QAsnUniResID resID = new QAsnUniResID();
    public int iEnableIpv6 = -1;
    public int isIpv6Addr = -1;
    public int isIpv4Addr = -1;

    public QAsnIPInterface() {
    }

    public QAsnIPInterface(QAsnIPInterface arg) {
        this.resID = new QAsnUniResID(arg.resID);
        this.iEnableIpv6 = arg.iEnableIpv6;
        this.isIpv6Addr = arg.isIpv6Addr;
        this.isIpv4Addr = arg.isIpv4Addr;
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        this.resID.serialize(enc);
        enc.serializeInteger(BigInteger.valueOf(this.iEnableIpv6));
        enc.serializeInteger(BigInteger.valueOf(this.isIpv6Addr));
        enc.serializeInteger(BigInteger.valueOf(this.isIpv4Addr));
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.resID.deserialize(dec);
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.iEnableIpv6 = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.isIpv6Addr = bi.intValue();
        }
        if (null != (bi = dec.deserializeInteger())) {
            this.isIpv4Addr = bi.intValue();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("resID = ");
        this.resID.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("iEnableIpv6 = ");
        os.print(this.iEnableIpv6);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isIpv6Addr = ");
        os.print(this.isIpv6Addr);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("isIpv4Addr = ");
        os.print(this.isIpv4Addr);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

