/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_l3vpn_model;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnISISProcessAuthentication
implements FStruct {
    public BigInteger authenticationType;
    public BigInteger encryptionMode;
    public BigInteger encryptionType;
    public byte[] password;
    public byte[] poKeyID = null;
    public BigInteger poOperMask = null;
    public BigInteger poAuthenticationMode = null;

    public QAsnISISProcessAuthentication() {
    }

    public QAsnISISProcessAuthentication(QAsnISISProcessAuthentication arg) {
        this.authenticationType = arg.authenticationType;
        this.encryptionMode = arg.encryptionMode;
        this.encryptionType = arg.encryptionType;
        this.password = new byte[arg.password.length];
        System.arraycopy(arg.password, 0, this.password, 0, arg.password.length);
        if (arg.poKeyID != null) {
            this.poKeyID = new byte[arg.poKeyID.length];
            System.arraycopy(arg.poKeyID, 0, this.poKeyID, 0, arg.poKeyID.length);
        }
        if (arg.poOperMask != null) {
            this.poOperMask = arg.poOperMask;
        }
        if (arg.poAuthenticationMode != null) {
            this.poAuthenticationMode = arg.poAuthenticationMode;
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeInteger(this.authenticationType);
        enc.serializeInteger(this.encryptionMode);
        enc.serializeInteger(this.encryptionType);
        enc.serializeOctetString(this.password);
        if (this.poKeyID != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeOctetString(this.poKeyID);
        }
        if (this.poOperMask != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            enc.serializeInteger(this.poOperMask);
        }
        if (this.poAuthenticationMode != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(this.poAuthenticationMode);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.authenticationType = dec.deserializeInteger();
        this.encryptionMode = dec.deserializeInteger();
        this.encryptionType = dec.deserializeInteger();
        this.password = dec.deserializeOctetString();
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            this.poKeyID = dec.deserializeOctetString();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.poOperMask = dec.deserializeInteger();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            this.poAuthenticationMode = dec.deserializeInteger();
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("authenticationType = ");
        os.print(this.authenticationType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("encryptionMode = ");
        os.print(this.encryptionMode.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("encryptionType = ");
        os.print(this.encryptionType.toString());
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("password = ");
        os.print(FStruFormat.convertToString((byte[])this.password));
        os.println(',');
        if (this.poKeyID != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poKeyID = ");
            os.print(FStruFormat.convertToString((byte[])this.poKeyID));
            os.println(',');
        }
        if (this.poOperMask != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poOperMask = ");
            os.print(this.poOperMask.toString());
            os.println(',');
        }
        if (this.poAuthenticationMode != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poAuthenticationMode = ");
            os.print(this.poAuthenticationMode.toString());
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

