/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_l3vpn_model;

import com.huawei.network.qasn.m_q_common.QAsnNVSList;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class QAsnArpItem
implements FStruct {
    public byte[] ipAddr;
    public byte[] macAddr;
    public int type = -1;
    public Integer poOperMask = null;
    public QAsnUniResID poOutIf = null;
    public Integer poVlan = null;
    public QAsnNVSList poExAttrList = null;

    public QAsnArpItem() {
    }

    public QAsnArpItem(QAsnArpItem arg) {
        this.ipAddr = new byte[arg.ipAddr.length];
        System.arraycopy(arg.ipAddr, 0, this.ipAddr, 0, arg.ipAddr.length);
        this.macAddr = new byte[arg.macAddr.length];
        System.arraycopy(arg.macAddr, 0, this.macAddr, 0, arg.macAddr.length);
        this.type = arg.type;
        if (arg.poOperMask != null) {
            this.poOperMask = arg.poOperMask;
        }
        if (arg.poOutIf != null) {
            this.poOutIf = new QAsnUniResID(arg.poOutIf);
        }
        if (arg.poVlan != null) {
            this.poVlan = arg.poVlan;
        }
        if (arg.poExAttrList != null) {
            this.poExAttrList = new QAsnNVSList(arg.poExAttrList);
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        int seq_nr = enc.serializeSequence();
        enc.serializeOctetString(this.ipAddr);
        enc.serializeOctetString(this.macAddr);
        enc.serializeInteger(BigInteger.valueOf(this.type));
        if (this.poOperMask != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)0));
            enc.serializeInteger(BigInteger.valueOf(this.poOperMask.intValue()));
        }
        if (this.poOutIf != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)1));
            this.poOutIf.serialize(enc);
        }
        if (this.poVlan != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)2));
            enc.serializeInteger(BigInteger.valueOf(this.poVlan.intValue()));
        }
        if (this.poExAttrList != null) {
            enc.setNextImplicit(Encoder.buildTag((int)2, (int)3));
            this.poExAttrList.serialize(enc);
        }
        enc.finishedBy(seq_nr);
    }

    public void deserialize(Decoder dec) throws FStruException {
        int seq_nr = dec.deserializeSequence();
        this.ipAddr = dec.deserializeOctetString();
        this.macAddr = dec.deserializeOctetString();
        BigInteger bi = dec.deserializeInteger();
        if (null != bi) {
            this.type = bi.intValue();
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)0))) {
            this.poOperMask = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)0));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poOperMask = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)1))) {
            this.poOutIf = new QAsnUniResID();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)1));
            this.poOutIf.deserialize(dec);
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)2))) {
            this.poVlan = new Integer(0);
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)2));
            bi = dec.deserializeInteger();
            if (null != bi) {
                this.poVlan = bi.intValue();
            }
        }
        if (!dec.isNextOptional(Decoder.buildTag((int)2, (int)3))) {
            this.poExAttrList = new QAsnNVSList();
            dec.setNextImplicit(Decoder.buildTag((int)2, (int)3));
            this.poExAttrList.deserialize(dec);
        }
        dec.finishedBy(seq_nr);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("ipAddr = ");
        os.print(FStruFormat.convertToString((byte[])this.ipAddr));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("macAddr = ");
        os.print(FStruFormat.convertToString((byte[])this.macAddr));
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("type = ");
        os.print(this.type);
        os.println(',');
        if (this.poOperMask != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poOperMask = ");
            os.print(this.poOperMask.toString());
            os.println(',');
        }
        if (this.poOutIf != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poOutIf = ");
            this.poOutIf.print(os, indent + 2);
            os.println(',');
        }
        if (this.poVlan != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poVlan = ");
            os.print(this.poVlan.toString());
            os.println(',');
        }
        if (this.poExAttrList != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("poExAttrList = ");
            this.poExAttrList.print(os, indent + 2);
            os.println();
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

