/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.network.qasn.m_q_ip_dmf;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.Encoder;
import net.commustru.fstru.FStruException;
import net.commustru.fstru.FStruct;
import net.commustru.util.FStruFormat;

public class AsnDmfUnionParaValue
implements FStruct {
    public static final int INTVAL_CID = 2;
    public static final int REALVAL_CID = 9;
    public static final int BOOLVAL_CID = 1;
    public static final int STRIVAL_CID = 4;
    int[] tag_list = new int[]{2, 9, 1, 4};
    public int choiceId;
    public BigInteger intVal = null;
    public double realVal;
    public boolean boolVal;
    public byte[] strIVal = null;

    public AsnDmfUnionParaValue() {
    }

    public AsnDmfUnionParaValue(AsnDmfUnionParaValue arg) {
        this.choiceId = arg.choiceId;
        switch (this.choiceId) {
            case 2: {
                this.intVal = arg.intVal;
                break;
            }
            case 9: {
                this.realVal = arg.realVal;
                break;
            }
            case 1: {
                this.boolVal = arg.boolVal;
                break;
            }
            case 4: {
                this.strIVal = new byte[arg.strIVal.length];
                System.arraycopy(arg.strIVal, 0, this.strIVal, 0, arg.strIVal.length);
            }
        }
    }

    public void serialize(Encoder enc) throws FStruException {
        enc.serializeChoice(this.choiceId, this.tag_list);
        switch (this.choiceId) {
            case 2: {
                enc.serializeInteger(this.intVal);
                break;
            }
            case 9: {
                enc.serializeDouble(this.realVal);
                break;
            }
            case 1: {
                enc.serializeBoolean(this.boolVal);
                break;
            }
            case 4: {
                enc.serializeOctetString(this.strIVal);
            }
        }
    }

    public void deserialize(Decoder dec) throws FStruException {
        this.choiceId = dec.deserializeChoice(this.tag_list);
        switch (this.choiceId) {
            case 2: {
                this.intVal = dec.deserializeInteger();
                break;
            }
            case 9: {
                this.realVal = dec.deserializeDouble();
                break;
            }
            case 1: {
                this.boolVal = dec.deserializeBoolean();
                break;
            }
            case 4: {
                this.strIVal = dec.deserializeOctetString();
            }
        }
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- CHOICE --");
        switch (this.choiceId) {
            case 2: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("intVal = ");
                os.print(this.intVal.toString());
                break;
            }
            case 9: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("realVal = ");
                os.print(this.realVal);
                break;
            }
            case 1: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("boolVal = ");
                os.print(this.boolVal);
                break;
            }
            case 4: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("strIVal = ");
                os.print(FStruFormat.convertToString((byte[])this.strIVal));
            }
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print("}");
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.print(ps);
        ps.close();
        return baos.toString();
    }
}

